/*******************************************************************************************
* FILE:			dl_V850ClientInterface.h
*
* SW-COMPONENT: Software Download
*
* DESCRIPTION: 
*				
*
* AUTHOR:		Aditya Kumar Jha
*
* COPYRIGHT:	(c) 2013  2014 Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
*********************************************************************************************
* HISTORY:
*				29.08.2013	Aditya Kumar Jha
*				Initial Version.
*				18.02.2014	Aditya Kumar Jha : added default argument to s32InitV850ClientHandler().
*           14.03.2014	Aditya Kumar Jha : Added ERROR CODE.
*           12.06.2014  Aditya Kumar Jha , Neera.K.Ponnappa : Implemented No CRC and No Reset
*           30.06.2014  Neera.K.Ponnappa : Implemented Security Bytes and Jtag ID
*           25.07.2014  Neera.K.Ponnappa : Implemented ClearCase label entry to registry
*           06.08.2014  Neera.K.Ponnappa : Bug Fix CMG3GB-reset issue when Security Bytes/Jtag Bytes executed.
*---------------------------------------------------------------------------------------------------
* 21-05-2015		| 2.1			| VRI7COB (RBEI)	| Changes are Made to Adapt For Adding the New Command line
* 					|				|					| Parameter "screenreinit"
*----------------------------------------------------------------------------------------------
* 19-02-2016		| 2.3	| VRI7COB (RBEI)	| Implementing the CRQ, CMG3G-9596
* --------------------------------------------------------------------------------------------------------------------
********************************************************************************************/

#ifndef _DL_V850CLIENTINTERFACE_H_
#define _DL_V850CLIENTINTERFACE_H_

#include "dl_V850MessageFactory.h"
#include "dl_V850UpdateCtrlManager.h"
using namespace std;
#include <string>
#include <list>

#define INIT_SUCCESS						0
#define UPDATE_SUCCESS					0
#define VER_INFO_SUCCESS				0
#define CRC_SUCCESS						0

#define ARGUMENT_ERROR					1
#define INIT_ERROR						2
#define FILE_CREATE_ERROR				3
#define TIMEOUT_ERROR					4

#define UPDATE_FAILED					5

#define REG_OPEN_ERROR					6
#define REG_CREATE_ERROR				7
#define REG_READ_ERROR					8
#define REG_WRITE_ERROR					9
#define REG_CLOSE_ERROR					10

#define CRC_UNINIT						11    
#define CRC_PENDING						12 	
#define CRC_PENDING_2					13 	
#define CRC_AREA_DCR_NOT_FOUND			14
#define CRC_AREA_DCR_FAILED				15
#define CRC_AREA_DCR_VER_FAILED			16
#define CRC_FAILED						17

//Security Error
#define SECURITY_ERROR					18
#define JTAG_VALIDATION_ERROR			19
#define JTAG_VALIDATION_NOTIMPLEMENTED	20
#define TOKEN_NOT_PRESENT				21
#define INVALID_FILE					22

#define INVALID_ERROR					100


// Security Bytes Max Limit
#define SECURITY_MAX_LIMIT        6
#define JTAG_BYTE_MAX             35

#define VERCHECK_FLAG			  7    
#define CRCCHECK_FLAG		      8 	
#define SECCHECK_FLAG			  9	
#define JTAGCHECK_FLAG		      10
#define INITAPPCHECK_FLAG		  11 	
#define UPDATECHECK_FLAG		  12	
#define RESETCHECK_FLAG			  13

//Security Validate Bytes
#define BOOT_BLOCK_ERASE_FLAG		0x01
#define BLOCK_ERASE_FLAG			0x02
#define CHIP_ERASE_FLAG				0x04
#define WRITE_FLAG					0x08
#define READ_FLAG					0x10

//It is for sending to V850.
#define BOOT_BLOCK_ERASE_INPUT_FLAG   "03"
#define BLOCK_ERASE_INPUT_FLAG		  "04"
#define CHIP_ERASE_INPUT_FLAG		  "05"
#define WRITE_ERASE_INPUT_FLAG		  "01"
#define READ_ERASE_INPUT_FLAG         "02"



class dl_tclV850ClientInterface
{

public:
	dl_tclV850ClientInterface();
	virtual ~dl_tclV850ClientInterface();

	tS32 s32InitV850ClientHandler( T_fCallback fCallback, tBool bIsAppStartOnly = false , tInt AppFlagVal = 0 );	
	
	tVoid vOnDLStart( tCString CStrFilePath, tU32 u32MemoryAddress );
	tBool bOnDLStart
		( 
			tCString CStrFilePath, 
			tCString CStrFileName, 
			list<EN_EXTRA_OPERATIONS> listofOpera,
			tBool bCrcEnabled = true, 
			tBool bResetEnabled = true 
		);
	tVoid vOnDLAbort() const;
	tVoid vOnDLUpdateProgress() const;
	tVoid vOnDLState() const;	
	tVoid vPostErrorToClient() const;
	tS8 s8OnGetSWVer(std::string& CStrFile, std::string& strVer, std::string& strLabel);
	tS8 s8OnGetCheckSumVal(std::string& CStrFile, std::string& strCheckSum);
	tVoid vOnResetReq();
	tVoid vOnGetSecurityByteVal(std::string& CStrSecByteVal, tBool bResetEnabled);
	tVoid vOnGetJtagByteVal(std::string& CStrJtagByteVal, tBool bResetEnabled);
	tVoid KillManagerThread() { m_oV850DlCtrlMgr.KillManagerThread(); }

	tU16 u16DoSecurityValidation(std::string strSecurityVal, tBool bResetEnabled);
	tU16 u16DoJTAGFingerprintValidation(std::string strjtagVal, tBool bResetEnabled);
	string  strReadSecuiryBitFromV850();



protected:
	dl_tclV850UpdateCtrlManager m_oV850DlCtrlMgr;

private:
	tVoid vAddRequestToMsgQ( tU8* message ) const;
	tS8 s8OnGetSWVerExtended();
	tVoid vAssignAppFlags(int AppFlagVal);

};
#endif // _DL_V850CLIENTINTERFACE_H_
