/*******************************************************************************************
* FILE:			dl_IncReceiver.h
*
* SW-COMPONENT:Software Download
*
* DESCRIPTION:	This file create a thread, whose job is to create a socket 
*					and listen to the port. Receive a message which is send to this port 
*					and post a message to V850 core control thread using message queue.
*				
* AUTHOR:		Aditya Kumar Jha
*
* COPYRIGHT:	(c) 2013  2014 Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
*********************************************************************************************
* HISTORY:
*					29.08.2013	Aditya Kumar Jha
*					Initial Version.
********************************************************************************************/

#ifndef _DL_INCRECEIVER_H_
#define _DL_INCRECEIVER_H_

#include "dl_V850MessageFactory.h"

using namespace std;
class MessageQueue;


class dl_tclIncReceiver
{

public:
	dl_tclIncReceiver();
	virtual ~dl_tclIncReceiver();

	tS32 s32CreateIncReceiverThread( sk_dgram * localDatagram );
	
	static void* vIncRecThreadCallBack(void* arg)
	{
		reinterpret_cast<dl_tclIncReceiver *>(arg)->vIncReceiverWorkedThread();
		return NULL;
	}
	tVoid vIncReceiverWorkedThread( );
	tVoid vSetReceiverThreadStatus( tBool bStatus );

private:
	tBool m_RunningRecvThread;
	sk_dgram *m_pDataGram;

	tVoid vPostMsgToV850DLCtrl( tU8* messaget, tS32 s32ReceivedMsg ) const;

};
#endif // _DL_INCRECEIVER_H_
