/*******************************************************************************************
* FILE:			 MessageQueue.h
*
* SW-COMPONENT: Software Download
*
* DESCRIPTION:  provides message queues for communication
*
* AUTHOR:		 Aditya Kumar Jha
*
* COPYRIGHT:	 (c) 2013  2014 Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
*********************************************************************************************
* HISTORY:
*					01.10.2013	Aditya Kumar Jha
*					Initial Version.
********************************************************************************************/

#ifndef MESSAGE_QUEUE_H
#define MESSAGE_QUEUE_H

#include "ai_osal_linux/components/system/system_types.h"

class MessageQueue
{

public:

	std::queue<tU8 *> mQueueHandlerIncReceiver;
	std::queue<tU8 *> mQueueHandlerClientReq;

	void vReqLock();
	void vRespLock();
	void vReqUnlock();
	void vRespUnlock();

	void vSendtoRespMsgQ(tU8 *message_in, tS32 s32ReceivedMsg);
	void vSendtoReqMsgQ(tU8 *message_in);

	~MessageQueue();

	MessageQueue();

private:

	//mutexes
	pthread_mutex_t m_reqMutex;
	pthread_mutex_t m_respMutex;

	void vDestroy();

};

#endif //MESSAGE_QUEUE_H
