/*******************************************************************************************
* FILE:			 MessageQueue.cpp
*
* SW-COMPONENT: Software Download
*
* DESCRIPTION:  provides message queues for communication
*
* AUTHOR:		 Aditya Kumar Jha
*
* COPYRIGHT:	 (c) 2013  2014 Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
*********************************************************************************************
* HISTORY:
*					01.10.2013	Aditya Kumar Jha
*					Initial Version.
*					21.05.2014	Aditya Kumar Jha
*					remove mutex lock.
********************************************************************************************/
#include <queue>
#include <string>
#include <pthread.h>
#include "MessageQueue.h"
#include "dl_V850MessageFactory.h"

using namespace std;

/***********************************************************************
* FUNCTION :		vSendtoRespMsgQ
*
* DESCRIPTION :	pushes message to mQueueHandlerIncReceiver queue
*
* PARAMETER :		tU8 *message_in 
*
* RETURNVALUE :	void 
*
* HISTORY :			01.10.2012
*						Initial version
*************************************************************************/
void MessageQueue::vSendtoRespMsgQ(tU8 *message_in, tS32 s32ReceivedMsg)
{
	/** DEEP Copy Done due to Overladed operator= in Utility */
	tU8 *object = new tU8[s32ReceivedMsg+1];

	/**To satisify the LINt : 429: Custodial Pointer*/
	tU8 *dummy = object;

	//push object only if it is not NULL
	if(NULL != object)
	{
		//object = message_in;
		memset(object, 0, s32ReceivedMsg+1);
		memcpy(object, message_in, s32ReceivedMsg);

		//pthread_mutex_lock(&m_respMutex);
		mQueueHandlerIncReceiver.push((tU8 *)object);

		//pthread_mutex_unlock(&m_respMutex);

	}

	/**To satisify the LINt : 429: Custodial Pointer*/
	dummy = NULL;

}

/***********************************************************************
* FUNCTION :		vSendtoReqMsgQ
*
* DESCRIPTION :	pushes message to mQueueHandlerClientReq queue 
*
* PARAMETER :		tU8 *message_in 
*
* RETURNVALUE :	void 
*
* HISTORY :			01.10.2012
*						Initial version
*************************************************************************/
void MessageQueue::vSendtoReqMsgQ(tU8 *message_in)
{
	/** DEEP Copy Done due to Overladed operator= in Utility */
	tU8 *object = new tU8[DEFAULT_MSGSZ];

	/**To satisify the LINt : 429: Custodial Pointer*/
	tU8 *dummy = object;

	//push object only if it is not NULL
	if(NULL != object)
	{
		*object = *message_in;
		//pthread_mutex_lock(&m_reqMutex);

		mQueueHandlerClientReq.push((tU8 *)object);

		//pthread_mutex_unlock(&m_reqMutex);
	}

	/**To satisify the LINt : 429: Custodial Pointer*/
	dummy = NULL;

}

/*************************************************************************
* FUNCTION :		vReqLock
*
* DESCRIPTION :	locks request mutex
*
* PARAMETER :		None
*
* RETURNVALUE :	void 
*
* HISTORY :			01.10.2012
*						Initial version
***************************************************************************/
void MessageQueue::vReqLock()
{
	pthread_mutex_lock(&m_reqMutex);
}

/**************************************************************************
* FUNCTION :		vRespLock
*
* DESCRIPTION :	locks Response mutex
*
* PARAMETER :		None
*
* RETURNVALUE :	void 
*
* HISTORY :			01.10.2012
*						Initial version
****************************************************************************/
void MessageQueue::vRespLock()
{
	pthread_mutex_lock(&m_respMutex);
}
/***************************************************************************
* FUNCTION :		vReqUnlock
*
* DESCRIPTION :	unlocks request mutex
*
* PARAMETER :		None
*
* RETURNVALUE :	void 
*
* HISTORY :			01.10.2012
*						Initial version
****************************************************************************/
void MessageQueue::vReqUnlock()
{
	pthread_mutex_unlock(&m_reqMutex);
}
/***************************************************************************
* FUNCTION :		vRespUnlock
*
* DESCRIPTION :	unlocks Response mutex
*
* PARAMETER :		None
*
* RETURNVALUE :	void 
*
* HISTORY :			01.10.2012
*						Initial version
****************************************************************************/
void MessageQueue::vRespUnlock()
{
	pthread_mutex_unlock(&m_respMutex);
}

MessageQueue::MessageQueue()
{
	//initialize mutexes 
	pthread_mutex_init(&m_reqMutex, NULL);
	pthread_mutex_init(&m_respMutex, NULL);

};

MessageQueue::~MessageQueue()
{
	vDestroy();
}

/*****************************************************************************
* FUNCTION :		vDestroy
*
* DESCRIPTION :	destroys mutexes 
*
* PARAMETER :		None
*
* RETURNVALUE :	void 
*
* HISTORY :			01.10.2012
*						Initial version
******************************************************************************/
void MessageQueue::vDestroy()
{
	pthread_mutex_destroy(&m_reqMutex);
	pthread_mutex_destroy(&m_respMutex);
}
