#include "util/swu_xmlItem.h"

#include "util/swu_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_UTIL
#include "trcGenProj/Header/swu_xmlItem.cpp.trc.h"
#endif

namespace swu {

XmlItemBase::XmlItemBase(XmlItemContainer *itemContainer, std::string key):
   _key(key) {
   ETG_TRACE_USR4(("XmlItemBase CTOR(%p); key=%s", itemContainer, _key.c_str()));
   itemContainer->registerItem(this);
};

void XmlItemBase::store(TiXmlElement *xmlRoot, std::string val) {
   ETG_TRACE_USR4(("XmlItemBase::store; key=%50s string val=%s", _key.c_str(), val.c_str()));
   setTextChild(xmlRoot, _key, val);
}

void XmlItemBase::restore(TiXmlElement *xmlRoot, std::string &val) {
   val=getTextFromChildOrEmpty(xmlRoot, _key.c_str());
   ETG_TRACE_USR4(("XmlItemBase::restore; key=%50s string val=%s", _key.c_str(), val.c_str()));
}

void XmlItemBase::store(TiXmlElement *xmlRoot, tUInt val) {
   traceVal("store");
   setUIntChild(xmlRoot, _key.c_str(), val);
}

void XmlItemBase::restore(TiXmlElement *xmlRoot, tUInt &val) {
   val=getUIntFromChild(xmlRoot, _key.c_str());
   traceVal("restore");
}

std::string const &XmlItemBase::getKey() {
   ETG_TRACE_USR4(("XmlItemBase::getKey; key=%s", _key.c_str()));
   return _key;
}

void XmlItemBase::traceVal(tUInt const &val, char const *action ) const {
   if (action) {
      ETG_TRACE_USR4(("XmlItemBase<tUInt>: key=%30s action=%10s val=%u", _key.c_str(), action, val));
   } else {
      ETG_TRACE_USR4(("XmlItemBase<tUInt>: key=%30s val=%u", _key.c_str(), val));
   }
}

void XmlItemBase::traceVal(std::string const &val, char const *action ) const {
   if (action) {
      ETG_TRACE_USR4(("XmlItemBase<std::string>: key=%30s action=%10s val=%s", _key.c_str(), action, val.c_str()));
   } else {
      ETG_TRACE_USR4(("XmlItemBase<std::string>: key=%30s val=%s", _key.c_str(), val.c_str()));
   }
}

void XmlItemContainer::registerItem(XmlItemBase *item) {
   ETG_TRACE_USR4(("XmlItemBase::registerItem(%p); key=%50s", item, item->getKey().c_str()));
   _items[item->getKey()]=item;
}

void XmlItemContainer::store(TiXmlElement *xmlRoot) {
   ETG_TRACE_USR4(("XmlItemContainer::store this=%p START xmlRoot=%p", this, xmlRoot));
   for (std::map<std::string, XmlItemBase *>::iterator iter=_items.begin();
        iter!=_items.end();
        ++iter) {
      ETG_TRACE_USR4(("XmlItemContainer::store: item"));
      XmlItemBase *xmlItem=iter->second;
      ETG_TRACE_USR4(("XmlItemContainer::store: item=%p", xmlItem));
      ETG_TRACE_USR4(("XmlItemContainer::store: key=%s", xmlItem->getKey().c_str()));
      xmlItem->store(xmlRoot);
   }
   ETG_TRACE_FATAL(("XmlItemContainer::store END"));
}

void XmlItemContainer::restore(TiXmlElement *xmlRoot) {
   ETG_TRACE_USR4(("XmlItemContainer::restore START xmlRoot=%p", xmlRoot));
   for (std::map<std::string, XmlItemBase *>::iterator iter=_items.begin();
        iter!=_items.end();++iter) {
      XmlItemBase *xmlItem=iter->second;
      ETG_TRACE_USR4(("XmlItemContainer::restore: found item=%p", xmlItem));
      ETG_TRACE_USR4(("XmlItemContainer::restore: key=%s", xmlItem->getKey().c_str()));
      xmlItem->restore(xmlRoot);
   }
   ETG_TRACE_USR4(("XmlItemContainer::restore END"));

}


}
