#ifndef SWU_TYPES_H
#define SWU_TYPES_H

//#include "config/swu_config.h"
#include <cassert>
// todo: osal conflicts with standard operator new included by ASF
#  include <string>
#  include <deque>
#  include <list>
#  include <vector>
#  include <map>
// #include <boost/ptr_container/ptr_vector.hpp>

#ifdef _LINUXX86MAKE_
#define SWU_EXIT(n) exit(n)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#define __PLACEMENT_NEW_INLINE
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

// include the global trace defines
#define ETG_ENABLED
#include "trace_interface.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#ifndef SWU_EXIT
#define SWU_EXIT(n) {                          \
      OSAL_vSetProcessExitCode(n);             \
      OSAL_vProcessExit();                     \
   }
#endif
#endif

#define SWU_ASSERT(a) if (!(a)) {::swu::traceAssert(__FILE__, __LINE__);assert(a);}
#define SWU_ASSERT_ALWAYS() ::swu::traceAssert(__FILE__, __LINE__); assert(0)
#define SWU_ASSERT_RETURN(a)  if (!(a)) {::swu::traceAssert(__FILE__, __LINE__); assert(0); return;}
#define SWU_ASSERT_RETURN_ALWAYS()  ::swu::traceAssert(__FILE__, __LINE__); assert(0); return
#define SWU_ASSERT_RETURN_VAL(a, val)  if (!(a)) {::swu::traceAssert(__FILE__, __LINE__); assert(0); return val;}
#define SWU_ASSERT_RETURN_FALSE(a)  if (!(a)) {::swu::traceAssert(__FILE__, __LINE__); assert(0); return false;}
#define SWU_ASSERT_RETURN_FALSE_ALWAYS() ::swu::traceAssert(__FILE__, __LINE__); assert(0); return false
#define SWU_ASSERT_RETURN_VAL_ALWAYS(val)  ::swu::traceAssert(__FILE__, __LINE__); assert(0); return val

#define SWU_CONCAT_(a, b) a##b
#define SWU_CONCAT(a, b) SWU_CONCAT_(a, b)

#define SWU_CHECK_POINTER_RETURN(a) if(!(a)) { return; }

#define SWU_ARRAY_SIZE(a) (sizeof(a)/sizeof(a[0]))
#define SWU_STATIC_ASSERT(expr)  enum { SWU_CONCAT(CompilerAssertAtLine, __LINE__) = sizeof( char[(expr) ? +1 : -1] ) }


//lint -sem(TiXmlNode::LinkEndChild,custodial(addThis))
//lint -function(new,tmpfile)

#ifndef __SW_UPDATE_UNIT_TESTING__

// Define to make a method virtual only for test environment -> So it is mapped to nothing in productive code
#define SWU_MOCK_VIRTUAL

#else

// Define to make a method virtual only for test environment
#define SWU_MOCK_VIRTUAL virtual

#endif


namespace swu {

void traceAssert(char const *file, unsigned int line);

template<class CLASS>
void deleteAndZero(CLASS *&p) {
   if (p) {
      delete p; p=0;
   }
}

template<class C>
class InstanceGetter {
public:
   InstanceGetter(C *c):
      _c(c)
   {}
   C *get() {
      return _c;
   }
   void set(C *c) {
      _c=c;
   }

private:
   C *_c;
};

}

#endif
