#ifndef SWU_TIMER_H
#define SWU_TIMER_H
#include "asf/core/Timer.h"

#include "util/swu_trace.h"
#include "util/swu_types.h"
#include "util/swu_msg.hpp"

namespace swu {

class  SwUpdTimerBase:   public ::asf::core::TimerCallbackIF {
public:
   virtual ~SwUpdTimerBase() {
   }

   virtual void onExpired( ::asf::core::Timer& timer, boost::shared_ptr< ::asf::core::TimerPayload> data) {
      traceInfo("SwUpdTimerBase:onExpired");
      fire();
   }
   void stop() {
      if(asfTimer.isActive()) {
         asfTimer.stop();
      }
   }

protected:
   virtual void fire() =0;
   ::asf::core::Timer asfTimer;
};



template<class USER, class MSG>
class SwUpdTimer : public SwUpdTimerBase {
public:
   //Coverity fix for 17703
   SwUpdTimer() : _usr( NULL ) {
   }
   void start(USER *usr, tUInt duration, MSG *msg=0) {
      traceInfo("SwUpdTimer:start");
      _usr = usr;
      if (msg) {
         _msg=*msg;
      }
      else {
         _msg=MSG();
      }
      asfTimer.start(*this, duration);
   }

   bool isRunning() {
      return asfTimer.isActive();
   }


protected:
   virtual void fire() {
      traceInfo("SwUpdTimer:fire?");
      
      if (_usr) {
         traceInfo("SwUpdTimer:fire!");
         _usr->vProcess(&_msg);
      }
   };
    
private:
   MSG _msg;
   USER *_usr;

};
}
#endif
