#ifndef SWU_THREAD_H
#define SWU_THREAD_H
#include <pthread.h>
#include "util/swu_types.h"
#include "util/swu_sem.h"

#include "util/swu_trace.h"


namespace swu {


class ThreadHelper {
public:
   static void traceAction(const char *action, bool initialized, bool running);
   static void traceVal(const char *action, int val);
   static void traceString(const char *str);
};

template <class THREAD>
class ThreadBase {
public:
   ThreadBase():running(false),initialized(false), threadHandle(0), param(0), sem() {
   };
   virtual ~ThreadBase() {
      stop();
   }
   void start() {
      ThreadHelper::traceAction("start() START", initialized, running);
      if (!initialized) {
         initialized=true;
         pthread_create(&threadHandle, NULL, theadFn_, (THREAD *)this);
         sem.lock();
         // we are sure now that the tread is running
      }
      ThreadHelper::traceAction("start() END", initialized, running);
   }
   void stop() {
      ThreadHelper::traceAction("stop() START", initialized, running);
      if (initialized) {
         int ret = pthread_cancel(threadHandle);
         ThreadHelper::traceVal("stop() pthread_cancel returned", ret);
         ret = pthread_join(threadHandle, 0);
         ThreadHelper::traceVal("stop() pthread_join returned", ret);
         running=false;
         initialized=false;
      }
      ThreadHelper::traceAction("stop() END", initialized, running);
   }
   static void * theadFn_(void *param) {
      ThreadHelper::traceString("theadFn_() START");
      THREAD *_this=(THREAD *)param;
      _this->running=true;
      _this->sem.unlock();
      ThreadHelper::traceString("theadFn_() call theadFn()");
      _this->theadFn();
      _this->running=false;
      ThreadHelper::traceString("theadFn_() END");
      return 0;
   }

   bool getIsRunning() {
      return running;
   }
   virtual void theadFn()=0;
private:
   bool running;
   bool initialized;
   pthread_t threadHandle;
   void *param;
   Sem sem;
};

}

#endif

