#ifndef SWU_STL_UTIL_HPP
#define SWU_STL_UTIL_HPP

#include <vector>
#include <string>
#include <algorithm> 

#include "util/swu_types.h"
#include "util/swu_trace.h"


namespace swu {

template <class COMP>
struct isMatched {
   COMP val;
   isMatched(COMP input) : val(input) {}
   bool operator () (COMP ref) const {
     return ref == val;
   }
};

template <class T, class CONT = std::vector<T> >
class stack {

public:
   CONT _elems;
   typedef typename CONT::iterator iterator;

public:
   std::string fmt;
   void push(T const& elem) {
      _elems.push_back(elem);
   }

   void pop() {
      if (!_elems.empty()) {
         _elems.pop_back(); 
      }      
   }

   bool empty() const {
      return _elems.empty();
   }

   T top() const {
      if (_elems.empty()) {
         return "";
      }
      return _elems.back();
   }

   void clear() {
      _elems.clear();
   }

   CONT getStack() {
      return _elems;
   }


   bool isPresent(T elem) {
      iterator pos = std::find_if(_elems.begin(), _elems.end(), isMatched<T>(elem));
      if (pos != _elems.end()) {
         return true;
      }
      return false;
   }
		
   T searchElem(T refElem) {
      T elem;
      iterator findIter = std::find_if(_elems.begin(), _elems.end(), isMatched<T>(refElem));			     
      if(findIter != _elems.end()) {
         elem = *findIter;
      }
      return elem;
   }
  
   void remove(T elem) {
      iterator pos = std::find_if(_elems.begin(), _elems.end(), isMatched<T>(elem));
      if (pos != _elems.end()) {
         _elems.erase(pos);
      }
   }
 
   T getElemFromIndex(tU16 index) {
      T elem;
      if(index <= _elems.size()) {
         elem = _elems.at(index);
      }
      return elem;
   }

   // Below warnings were observed for -
   // gen3armmake, gen3x86make, gen4rcar, gen4lsim: conversion to 'tU16 {aka short unsigned int}' from 'std::vector<std::__cxx11::basic_string<char> >::size_type {aka unsigned int}'
   // gen3armmake, gen3x86make, gen4rcar, gen4lsim: conversion to 'tU16 {aka short unsigned int}' from 'std::vector<fcswupdate::ResourceData, std::allocator<fcswupdate::ResourceData> >::size_type {aka unsigned int}'
   // So the return type is changed to long unsigned int
   long unsigned int getSize() {
      return _elems.size();
   }
   
   void traceStack() {
      iterator iter;
      for (iter = _elems.begin(); iter != _elems.end(); iter++) {
         T elem = *iter;				
         std::string msg = "element:" + fmt;
         SWU_TRACE_VARG_USR1(msg.c_str(), elem.c_str());
      }
   }	
};

	
}

#endif
