/**
 * @file      swu_sourceSdc.hpp
 * @author    Philipp Blanke (blp4hi) <philipp.blanke@de.bosch.com>
 * @date      Thu 15 Oct 2015, 17:01
 * @copyright Robert Bosch Car Multimedia GmbH
 * @brief     Description
 *
 * Detailed description of file.
 */

#ifndef SWU_SOURCESDC_HPP
#define SWU_SOURCESDC_HPP

#include <string>
#include <vector>

#ifdef GEN3ARM
#include "sdc.h"
#else
typedef  int sdc_key_id_t;
#define SDC_FLAG_INVALID_KID 0
#endif
#include "util/swu_crypto.hpp"
namespace swu
{

/** @brief Allows reading of files encrypted and signed with SDC. */
class SourceSdc
{
   sdc_key_id_t _kid;

public:
   /** @brief C'tor which takes a key id as argument. Default is "invalid key".
    *
    *  If no key ID is given, the container will try to get the correct key id
    *  from a formatted buffer during a read(). If a key ID is provided, this
    *  will be used for read().
    */
   SourceSdc (sdc_key_id_t kid = SDC_FLAG_INVALID_KID);

   /** @brief Read data from an encrypted file and return it as a byte array.
    *
    * @return If successful the decrypted data, otherwise an empty vector.
    */
   bool read (std::vector<SWU_BYTE>& data, const std::string& fileName) const;
};

}

#endif /* !SWU_SOURCESDC_HPP */
