#ifdef GEN3ARM
#include "adit-components/sdc_session.h"
#include "adit-components/sdc_op_common.h"
#include "adit-components/sdc_op_conv.h"
#endif

#include "util/swu_filesystem.h"
#include "util/swu_sourceSdc.hpp"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_UTIL
#include "trcGenProj/Header/swu_sourceSdc.cpp.trc.h"
#endif 

namespace swu
{
   SourceSdc::SourceSdc (sdc_key_id_t kid)
      : _kid(kid)
   { }

   bool SourceSdc::read (std::vector<SWU_BYTE>& data, const std::string& fileName) const
   {
#ifdef GEN3ARM

      std::vector<SWU_BYTE> eData;  // Encrypted data
      SWU_BYTE* eBuf = 0;           // Encrypted data buffer
      size_t eLen    = 0;
      SWU_BYTE* dBuf = 0;           // Decrypted data buffer
      size_t dLen    = 0;

      sdc_session_t* session           = 0;
      sdc_wrap_unwrap_type_t* wrapType = 0;
      sdc_error_t result;

      // open file and read content
      if (! swu::loadFile(fileName, eData) ) {
         return false;
      }
      eBuf = &eData[0];
      eLen = eData.size();

      bool ret = true;

      // decrypt content 
      do { // emulate goto cleanup
         result = sdc_open_session(&session);
         if (result != SDC_OK) { break; }
         
         // load key id from encrypted file, unless its set
         if (_kid == SDC_FLAG_INVALID_KID) {
            result = sdc_unwrap_formatted_autoload_key(session, eBuf, eLen);
         }
         else {
            result = sdc_session_load_storage_key(session, _kid);
         }
         if (result != SDC_OK) { break; }

         result = sdc_unwrap_formatted_extract_type(eBuf, eLen, &wrapType);
         if (result != SDC_OK) { break; }

         result = sdc_unwrap_formatted(session, wrapType, eBuf, eLen, &dBuf, &dLen);
         if (result != SDC_OK) { break; }

         try {
            data.reserve(dLen);
            data.assign(dBuf, dBuf+dLen);
         }
         catch (std::exception& e) {
            ETG_TRACE_ERR(( "Can not copy unencrypted data." ));
            ret = false;
         }
      } while (false);
   
      if (result != SDC_OK) {
         ETG_TRACE_ERR(( "SDC error: %s", sdc_get_error_string(result) ));
         ret = false;
      }

      // cleanup:
      if (wrapType) { result = sdc_wrap_unwrap_type_free(wrapType); }
      if (dBuf)     { result = sdc_plain_buffer_free(dBuf, dLen); }
      if (session)  { result = sdc_close_session(session); }

      if (result != SDC_OK) {
         ETG_TRACE_ERR(( "SDC error: %s", sdc_get_error_string(result) ));
      }

      return ret;
#else 
      return true;
#endif 

   }

}
