#include <string>
#include "util/swu_constants.hpp"
#include "util/swu_crypto.hpp"

namespace swu {

/** @brief Allows reading and writing from NOR memory. */
class SourceNOR {
   std::string _pathDevice;
   std::string _pathBlockDevice;

   public:
   SourceNOR (
         const std::string& dev = swu::Constants::Mmc::MTD0_DEVICE_NAME,
         const std::string& blkDev = swu::Constants::Mmc::MTD0_BLOCK_DEVICE_NAME);

   /** @brief Reads data from the memory block defined by offset and length.
    *
    *  @param data    The data read will be stored here.
    *  @param offset    Start address of the data block.
    *  @param length    Length of the data block to read.
    *
    *  @return    False, if the data block is zeroed or erased, or if the data
    *             block can't be read. Otherwise true.
    */
   bool read (std::vector<SWU_BYTE>& data, uint32_t offset, uint32_t length);
};

}
