#include <fcntl.h>   // open()
#include <unistd.h>  // lseek()

#include "util/swu_sourceNor.hpp"
#include "util/swu_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_UTIL
#include "trcGenProj/Header/swu_sourceNor.cpp.trc.h"
#endif 

namespace swu
{

   SourceNOR::SourceNOR (
         const std::string& dev,
         const std::string& blkDev)
      : _pathDevice(dev), _pathBlockDevice(blkDev)
   {
   }

   bool SourceNOR::read (
         std::vector<SWU_BYTE>& data,
         uint32_t offset, uint32_t length)
   {
      int fd = 0;
      SWU_BYTE* buffer = 0;
      const char* path = _pathDevice.c_str();

      fd = ::open(path, O_RDONLY);
      if(fd == -1) {
         ETG_TRACE_ERR(("Can't open NOR memory for reading: %s", path));
         ETG_TRACE_ERR(("Trying alternative device."));
         path = _pathBlockDevice.c_str();
         fd = ::open(path, O_RDONLY);
         if(fd == -1) {
            ETG_TRACE_ERR(("Also can't open %s, bailing out.", path));
            return false;
         }
      }
      ETG_TRACE_USR3(("Reading from %11s, seek %7i, length %i", path, offset, length));

      int res = static_cast<int> (::lseek(fd, offset, SEEK_SET));
      if(static_cast<int> (offset) != res) { // gen3armake, gen3x86make, gen4lsim, gen4rcar: comparison between signed and unsigned integer expressions
         ::close(fd);
         ETG_TRACE_ERR(("Can't lseek in NOR memory %s", path));
         return false;
      }

      buffer = new SWU_BYTE[length];
      if(static_cast<int> (length) != ::read(fd, buffer, length)) {  // gen3armake, gen3x86make, gen4lsim, gen4rcar: comparison between signed and unsigned integer expressions
         ::close(fd);
         delete[] buffer;
         ETG_TRACE_ERR(("Can't read %s", path));
         return false;
      }
      ETG_TRACE_USR3(("Read %i bytes.", length));
      data.resize(length);
      data.assign(buffer, buffer+length);

      ::close(fd);
      delete[] buffer;

      return true;
   }
}
