#ifndef SWU_SEM_HPP
#define SWU_SEM_HPP

namespace swu {
class Sem {
public:
   Sem():_bValid(0) {
      int rc=0;
      pthread_mutexattr_t  attr;
      rc = pthread_mutexattr_init(&attr);
      SWU_ASSERT_RETURN(0 == rc);
      rc = pthread_mutexattr_settype(&attr, PTHREAD_MUTEX_RECURSIVE); 
      SWU_ASSERT_RETURN(0 == rc);
      rc = pthread_mutex_init (&_mutex,
                               &attr);
      SWU_ASSERT_RETURN(0 == rc);
      rc = pthread_mutexattr_destroy(&attr);
      SWU_ASSERT_RETURN(0 == rc);
      _bValid=1;
   }

   tVoid lock() {
      if (_bValid) {
         pthread_mutex_lock( &_mutex ); 
      }
   }

   tVoid unlock() {
      if (_bValid) {
         pthread_mutex_unlock( &_mutex ); 
      }
   }

private:
   pthread_mutex_t _mutex;
   tBool _bValid;
};

}


#endif
