#include <sstream>

#include "util/swu_types.h"

// linking registry access functions
#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#include "util/swu_registry.h"
#include "util/swu_util.hpp"


#include "util/swu_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_UTIL
#include "trcGenProj/Header/swu_registry.cpp.trc.h"
#endif

using namespace std;

namespace swu {


// needed defines to access Registry:
#define SWU_MAX_REG_VAL_LEN 100

RegUtil::RegUtil(string path):
   _path(path),
   _bOpen(FALSE)
{
   _oReg=new reg_tclRegKey();
};

RegUtil::~RegUtil() {
   vClose();
   _path="";
   delete _oReg;
   _oReg=0;
}

bool RegUtil::bOpen() {
   if (!_bOpen && _path.size()) {
      SWU_ASSERT_RETURN_FALSE(_oReg);
      _bOpen=_oReg->bOpen(_path.c_str());
      if (!_bOpen) {
         ETG_TRACE_ERR(("RegUtil: Open REG-path (%s) failed !!!",
                        _path.c_str()));
      }
   }
   return _bOpen;
};

tVoid RegUtil::vClose() {
   if (_bOpen) {
      SWU_ASSERT_RETURN(_oReg);
      _oReg->vClose();
      _bOpen=FALSE;
   }
};

bool RegUtil::write(string key, string val) {
   bool bSuccess=FALSE;
   if (bOpen()) {
      ETG_TRACE_USR3(("RegUtil: write: key=%30s, value=%30s",
                      key.c_str(), val.c_str()));
      SWU_ASSERT_RETURN_FALSE(_oReg);
      bSuccess =_oReg->bSetString(key.c_str(), (char *)val.c_str(),static_cast<tU32> (val.size() ));
      if (!bSuccess) {
         ETG_TRACE_ERR(("RegUtil: write REG failed !!!"));
      }
   }
   return bSuccess;
}

bool RegUtil::write(string key, tU32 val) {
   bool bSuccess=FALSE;
   if (bOpen()) {
      ETG_TRACE_USR3(("RegUtil: write: key=%30s, value=%u (0x%08x)",
                      key.c_str(), val, val));
      
      bSuccess =_oReg->bSetU32(key.c_str(), val);
      if (!bSuccess) {
         ETG_TRACE_ERR(("RegUtil: write REG failed !!!"));
      }
   }
   return bSuccess;
}

bool RegUtil::write(string key, std::vector<tU8> val) {
   bool bSuccess=FALSE;
   if (bOpen()) {
      std::string strVal=binToHex(val);
      ETG_TRACE_USR3(("RegUtil: write: key=%30s, value=%s",
                      key.c_str(), strVal.c_str()));
      
      bSuccess =_oReg->bSetString(key.c_str(), (char *)strVal.c_str(),static_cast<tU32> (strVal.size() ));
      if (!bSuccess) {
         ETG_TRACE_ERR(("RegUtil: write REG failed !!!"));
      }
   }
   return bSuccess;
}

bool RegUtil::read(string key, tU32 &val) {
   bool bSuccess=FALSE;
   if (bOpen()) {
      bSuccess = _oReg->bQueryU32(key.c_str(), &val);
      ETG_TRACE_USR3(("RegUtil: Read: key=%30s, bSuccess=%u, val=%u (0x%08x)",
                      key.c_str(), bSuccess, val, val));
      
      if (!bSuccess) {
         ETG_TRACE_ERR(("RegUtil: Read REG failed !!!"));
      }
   }
   return bSuccess;
}

bool RegUtil::read(string key, string &val) {
   bool bSuccess=FALSE;
   val="";
   if (bOpen()) {
      char buf[SWU_MAX_REG_VAL_LEN + 1];
      bSuccess = _oReg->bQueryString(key.c_str(), buf, SWU_MAX_REG_VAL_LEN);
      buf[SWU_MAX_REG_VAL_LEN]=0;
      val=buf;
      ETG_TRACE_USR3(("RegUtil: Read: key=%30s, bSuccess=%u, val=%s",
                      key.c_str(), bSuccess, val.c_str()));
      
      if (!bSuccess) {
         ETG_TRACE_ERR(("RegUtil: Read REG failed !!!"));
      }
   }
   return bSuccess;
}


bool RegUtil::read(string key, std::vector<tU8> &val) {
   bool bSuccess=FALSE;
   if (bOpen()) {
      char buf[SWU_MAX_REG_VAL_LEN + 1];
      bSuccess = _oReg->bQueryString(key.c_str(), buf, SWU_MAX_REG_VAL_LEN);
      buf[SWU_MAX_REG_VAL_LEN]=0;

      if (!bSuccess) {
         ETG_TRACE_ERR(("RegUtil: Read REG failed !!!"));
      }
      std::string strVal=buf;
      ETG_TRACE_USR3(("RegUtil: Read: key=%30s, bSuccess=%u, val=%s",
                      key.c_str(), bSuccess, strVal.c_str()));
      bSuccess=hexToBin(strVal,val);
   }
   return bSuccess;
}











}



