#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <string.h>
#include <fstream>

#include "util/swu_types.h"
#include "util/swu_util.hpp"
#include "util/swu_constants.hpp"
#include "util/swu_bootChain.h"
#include "util/swu_rawRegistry.h"
#include "util/swu_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_UTIL
#include "trcGenProj/Header/swu_rawRegistry.cpp.trc.h"
#endif 

using namespace std;

namespace swu {

bool RawRegistryStringItemDescription::read(string &val){
   RawRegistry reg;
   return reg.getRegistryItem(_key, val);
}
bool RawRegistry::getRegistryItem(std::string name, std::string &value)
{
   if(0 == name.size())
   {
      ETG_TRACE_ERR(("getRegistryItem: wrong input parameter"));
      return false;
   }
   int handle;
   int actibeBootChain, &actibeBootChainRef = actibeBootChain;
   if(false == BootChain::usedBootChain(actibeBootChainRef))
   {
      ETG_TRACE_ERR(("getRegistryItem: Can't get active bootchain"));
      return false;
   }
   uint32_t registryOffset;
   int32_t registrySize;
   std::string mmcDeviceName;
   registryOffset = Constants::Mmc::OFFSET_BOOT_CHAIN1_REGISTRY;
   registrySize = Constants::Mmc::SIZE_BOOT_CHAIN_REGISTRY;
   mmcDeviceName = Constants::Mmc::MMC_WHOLE_DEVICE_NAME;
   if(2 == actibeBootChain)
   {
      registryOffset = Constants::Mmc::OFFSET_BOOT_CHAIN2_REGISTRY;
   }
   
   //try to open file
   if (-1 == (handle = open(mmcDeviceName.c_str(), O_RDONLY))) {
      ETG_TRACE_ERR(("getRegistryItem: Can't open %s", mmcDeviceName.c_str()));  
      return false;
   }
   
   if(registryOffset != lseek(handle, registryOffset, SEEK_SET)) {
      ETG_TRACE_ERR(("getRegistryItem: Can't lseek %s", mmcDeviceName.c_str())); 
      close(handle);
      return false;
   }
   
   char buffer[registrySize];
   if(registrySize != read(handle, buffer, registrySize)) {
      ETG_TRACE_ERR(("getRegistryItem: Can't read %s", mmcDeviceName.c_str()));
      close(handle);
      return false;
   }   
   close(handle);
   
   std::string registry;
   registry.assign(buffer, registrySize);
   std::string nextLine;
   while (0 != (nextLine = extractLine(registry)).size()) {

      ETG_TRACE_FATAL(("RawRegistry::getRegistryItem: line Read:%s", nextLine.c_str()));
      
      if(';' == *nextLine.c_str()) continue;    // skip comment line starting with ';'
      const char *ptrKey;
      if(0 != (ptrKey = strstr(nextLine.c_str(), name.c_str()))) {
         nextLine.assign(ptrKey + name.size());
         if(0 != (ptrKey = strstr(nextLine.c_str(), "\""))) {
            value.assign(nextLine.c_str(), ptrKey - nextLine.c_str());
            return true;
         }
      }
   }
   return false;
}

}

