
#ifndef SWU_PROPERTY_HPP
#define SWU_PROPERTY_HPP

#include "util/swu_msg.hpp"
#include "util/swu_member.hpp"


namespace swu {

/*
	Message-classes the can be broadcasted
*/
// the base-class for all messages
/*
  subscibing to a property is done by subscibing to MSG.
  attention: received MSG does not always reflect static value of property.
  Always use access() or get() to get the actual value of the property! 
 */

template<class MSG>
class Property:
      public Member<typename MSG::compType>
{
public:
   // pure virtual method to force to derive from this class for usage
   virtual const char *getName()=0;
   MSG const &get() {
      return _msg;
   };
   
   virtual void traceState()=0;
   
   void set(MSG *msg) {
      if (*msg != _msg) {
         _msg=*msg;
         msg=new MSG(_msg);
         Member<typename MSG::compType>::notifyLater(msg);
      }
   };

   MSG &access() {
      return _msg;
   };
   

   template<class CLASS>
   bool iNotify(CLASS *) {
      typename CLASS::compType *pClass= (typename MSG::compType *)0;
      return Member<typename MSG::compType>::notify(_msg);
   };

   void notifyLater() {
      MSG *msg=new MSG(_msg);
      Member<typename MSG::compType>::notifyLater(msg);
   }

   template<class CLASS>
   void upreg(CLASS *c) {
      _msg.vSubscribe(c);
      c->vProcess(&_msg); // peha todo delete or async?
   };
   
   template<class CLASS>
   void relupreg(CLASS *c) {
      _msg.vUnSubscribe(c);
   };

protected:
   MSG _msg;
};

}

#endif

