#include <sstream>
#include <fstream>

#include "util/swu_types.h"
#include "util/swu_filesystem.h"
#include "util/swu_otp.h"


#include "util/swu_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_UTIL
#include "trcGenProj/Header/swu_otp.cpp.trc.h"
#endif

#define FUSE_FILE_NAME          "/sys/kernel/debug/regmap/21bc000.ocotp/registers"
#define FUSE_FILE_LINE_LENGTH   15
#define FUSE_FILE_ID_LENGTH     4
#define FUSE_FILE_VALUE_OFFSET  6
#define FUSE_FILE_VALUE_LENGTH  8

namespace swu
{
    OTPDriver   *OTPDriver::Instance=NULL;

    OTPDriver *OTPDriver::GetInstance(void)
    {
        if(!Instance)
            Instance=new OTPDriver();

        return Instance;
    }

    bool OTPDriver::GetData(unsigned int *Value, unsigned int FuseID)
    {
        OTPDataMap::const_iterator  iter;

        if(!DataMap.size() && !ReadOTPArea())
            return false;

        if((iter=DataMap.find(FuseID))==DataMap.end())
            return false;

        *Value=(*iter).second;
        return true;
    }

    OTPDriver::OTPDriver()
    {
    }

    OTPDriver::~OTPDriver()
    {
        Instance=NULL;
    }

    bool OTPDriver::ParseHexChar(unsigned int *Value, const unsigned char Char)
    {
        if(Char>='0' && Char<='9')
            *Value=(*Value<<4)+Char-'0';
        else if(Char>='a' && Char<='f')
            *Value=(*Value<<4)+10+Char-'a';
        else if(Char>='A' && Char<='F')
            *Value=(*Value<<4)+10+Char-'A';
        else
            return false;
        return true;
    }

    bool OTPDriver::AddToMap(const unsigned char *Buff, const int BuffLen)
    {
        unsigned int key=0, value=0;

        if(BuffLen<FUSE_FILE_LINE_LENGTH-1)
            return false;

        for(int i=0; i<FUSE_FILE_ID_LENGTH; i++)
            if(!ParseHexChar(&key, Buff[i]))
                return false;

        if(Buff[FUSE_FILE_ID_LENGTH]!=':' || Buff[FUSE_FILE_ID_LENGTH+1]!=' ')
            return false;

        for(int i=0; i<FUSE_FILE_VALUE_LENGTH; i+=2)
        {
            if(!ParseHexChar(&value, Buff[FUSE_FILE_VALUE_OFFSET+i]))
                return false;
            if(!ParseHexChar(&value, Buff[FUSE_FILE_VALUE_OFFSET+i+1]))
                return false;
        }

        DataMap[key]=value;

        return true;
    }

    bool OTPDriver::ReadOTPArea(void)
    {
        FILE            *otp_file;
        unsigned char   buff[FUSE_FILE_LINE_LENGTH];
        int             bufflen=0;
        bool            result=false;

        DataMap.clear();
        if(!(otp_file=fopen(FUSE_FILE_NAME, "r")))
        {
            ETG_TRACE_ERR(("OTPDriver::ReadOTPArea(): Failed to open otp file"));
        }
        else
        {
            memset(buff, 0, sizeof(buff));
            for(int c=fgetc(otp_file); c!=EOF; c=fgetc(otp_file))
            {
                if(bufflen >= static_cast<int> (sizeof(buff)))  // gen3armake, gen3x86make, gen4lsim, gen4rcar: comparison between signed and unsigned integer expressions
                {
                    ETG_TRACE_ERR(("OTPDriver::ReadOTPArea() buffsize exceeded"));
                    goto FAIL;
                }
                if(c!='\n')
                    buff[bufflen++]=(unsigned char)c;
                else
                {
                    if(!AddToMap(buff, bufflen))
                    {
                        ETG_TRACE_ERR(("OTPDriver::ReadOTPArea() add failed"));
                        goto FAIL;
                    }
                    memset(buff, 0, sizeof(buff));
                    bufflen=0;
                }
            }
            if(bufflen && !AddToMap(buff, bufflen))
            {
                ETG_TRACE_ERR(("OTPDriver::ReadOTPArea() add failed"));
                goto FAIL;
            }
            result=true;
        }
        goto DONE;

    FAIL:
        DataMap.clear();

    DONE:
        if(otp_file)
            fclose(otp_file);

        return result;
    }
}
