#ifndef SWU_OSAL_DEVICE_HPP
#define SWU_OSAL_DEVICE_HPP

#include "util/swu_types.h"


namespace swu {

class OsalDevice {
public:
   OsalDevice(std::string const &name);
   ~OsalDevice();

   bool bOpen();
   void vClose();


   bool isOpen() {
      return _deviceHandle!=OSAL_ERROR;
   }

   OSAL_tIODescriptor getHandle();
private:
   OSAL_tIODescriptor   _deviceHandle;
   std::string _name;
};

/*
  Helper for OSAL-Gpios
*/
class OsalGpio {
 public:
   OsalGpio(tU32 pinId);
   ~OsalGpio();
   
   bool bOpen();
   void vClose();
   bool bSet(bool bState);


 private:
   const tU32 _pinId;
   OsalDevice _device;
};



}

#endif
