#include "swu_osalDevice.hpp"

#include "util/swu_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_UTIL
#include "trcGenProj/Header/swu_osalDevice.cpp.trc.h"
#endif

using namespace std;

namespace swu {

OsalDevice::OsalDevice(string const &name):
   _deviceHandle(OSAL_ERROR),
   _name(name)
{
   ETG_TRACE_ERR(("OsalDevice CTOR: name=%s", _name.c_str()));
}

OsalDevice::~OsalDevice() {
   ETG_TRACE_ERR(("OsalDevice DTOR: name=%s", _name.c_str()));
   vClose();
}

bool OsalDevice::bOpen() {
   ETG_TRACE_ERR(("OsalDevice DTOR: name=%s", _name.c_str()));
   _deviceHandle = OSAL_IOOpen(_name.c_str(), OSAL_EN_READWRITE);
   if (_deviceHandle==OSAL_ERROR) {
      ETG_TRACE_ERR(("OsalDevice::open(): OSAL_IOOpen failed"));
   }
   return isOpen();
}

void OsalDevice::vClose() {
   if (_deviceHandle != OSAL_ERROR) {
      OSAL_s32IOClose(_deviceHandle);
      _deviceHandle=OSAL_ERROR;
   }
}

OSAL_tIODescriptor OsalDevice::getHandle() {
   if (!isOpen()) {
      bOpen();
   }
   return _deviceHandle;
}



// Class OsalGpio
OsalGpio::OsalGpio(tU32 pinId):
   _pinId(pinId),
   _device(OSAL_C_STRING_DEVICE_GPIO)
{
   ETG_TRACE_ERR(("OsalGpio CTOR START _pinId=%u ", _pinId));
}

OsalGpio::~OsalGpio() {
   ETG_TRACE_ERR(("OsalGpio DTOR START _pinId=%u ", _pinId));
   vClose();
}

bool OsalGpio::bOpen() {
   return _device.bOpen();
}

void OsalGpio::vClose() {
   _device.vClose();
}


bool OsalGpio::bSet(bool bState) {
   bool res=true;
   ETG_TRACE_ERR(("OsalGpio:bSet() START _pinId=%u bState=%u", _pinId, bState));
   bool allreadyOpen=_device.isOpen();
   if (!allreadyOpen && !_device.bOpen()) {
      return false;
   }
   OSAL_trGPIOData pinData;
   pinData.tId          = _pinId;
   pinData.unData.bState   = bState? TRUE : FALSE; //TRUE == HIGH, // FALSE == LOW
   if (OSAL_OK !=  OSAL_s32IOControl(_device.getHandle(),OSAL_C_32_IOCTRL_GPIO_SET_ACTIVE_STATE, (intptr_t) &pinData)) {
      ETG_TRACE_ERR(("OsalGpio:bSet() OSAL_s32IOControl failed"));
      res=false;
   }

   if (!allreadyOpen) {
      _device.vClose();
   }
   return res;
}

}
