#ifndef SWU_MSG_CALLER_BASE_HPP
#define SWU_MSG_CALLER_BASE_HPP

#include <stdio.h>
#include "util/swu_types.h"

#include "util/swu_trace.h"

namespace swu {

// forward-declaration of member.
// only members may receive messages
// iNotify is only allowed between classes that belong to same component 
class MemberMsg;

// forward-declaration of base-class for all messages
class MsgBase;
// base-class for all callers
class MsgCallerBase {
public:
  typedef enum  {
    tenState_idle,
    tenState_busy,
    tenState_deleted
  } tenState;
	// pure-virtual, only derived class knows the real type of the message
    virtual tVoid vCall(MsgBase *pMsg)=0;

	// put myself to the list of subsriptions kept by each member
   MsgCallerBase(std::list<MsgCallerBase *> *poSubcriberList, bool hasPrio);
   virtual ~MsgCallerBase();
   virtual MemberMsg *getMember()=0;
   bool hasMember(MemberMsg *member);
    tenState _enState;
    // list where this caller has been put:
    std::list<MsgCallerBase *> *_poSubcriberList;
    
};

}

#endif
