#include "swu_msgCallerBase.hpp"
#include "util/swu_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_UTIL
#include "trcGenProj/Header/swu_msgCallerBase.cpp.trc.h"
#endif

using namespace std;

namespace swu {




MsgCallerBase::MsgCallerBase(list<MsgCallerBase *> *poSubcriberList, bool hasPrio):_enState(tenState_idle), _poSubcriberList(poSubcriberList)
    {
       if (hasPrio)  {
          _poSubcriberList->push_front(this);          
       } else {
          _poSubcriberList->push_back(this);
       }
    }

       MsgCallerBase::~MsgCallerBase() {	   
       // _poSubsriberList is pointer to the subsriber-list of the member that is target of the subsription
       // we have to remove our entry from this list when we are deleted
	    
		ETG_TRACE_USR1(("In MsgCallerBase Destructor"));			
       for (list<MsgCallerBase *>::iterator iter=_poSubcriberList->begin(); 
            iter!=_poSubcriberList->end();++iter) {		
			
			ETG_TRACE_USR1(("MsgCallerBase Destructor::%p",*iter));
          if (*iter==this) {
             ETG_TRACE_USR1(("MsgCallerBase removing::%p",*iter));
             _poSubcriberList->erase(iter);
             break;
          }
       }
    }

      bool MsgCallerBase::hasMember(MemberMsg *member) {
      for(list<MsgCallerBase *>::iterator iter= _poSubcriberList->begin();iter!=_poSubcriberList->end();++iter) {
         MsgCallerBase *caller=*iter;
         MemberMsg *subscribedMember=caller->getMember();

         if (subscribedMember==member) {
            return true;
         }
      }
      return false;
   } 
}
