#ifndef SWU_MEMBER_LIST_HPP
#define SWU_MEMBER_LIST_HPP

#include "swu_member.hpp"


namespace swu {


/*
 list keeping track of members.
 */
class MemberListBase {
public:

   MemberListBase() :
         _bInitialized(FALSE) {
   }

   virtual ~MemberListBase();

   void traceState(char const  *owner);
   
   tVoid vInit();

   tVoid vDeInit();

   tVoid vClear();
   MemberSimple* addMember(MemberSimple *pMember){
      addMember((MemberBase *)pMember);
      return pMember;
   }
   tVoid removeMember(MemberBase *pMember);
   tVoid deleteMember_(MemberBase *pMember);
   
   template<class CLASS>
   tVoid deleteMember(CLASS *&p) {
      MemberBase *pBase=p;
      deleteMember_(pBase);
      p=0;
   }
protected:
   MemberBase * addMember(MemberBase *pMember);
   tBool _bInitialized;
   std::deque<MemberBase *> _members;

};

template<class COMP>
class MemberList: public MemberListBase {
public:


   using MemberListBase::addMember;


   Member<COMP> *addMember(Member<COMP> *pMember) {
      MemberListBase::addMember(pMember);
      return pMember;
   }





};

}
#endif
