#include "swu_memberList.hpp"

#include "util/swu_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_UTIL
#include "trcGenProj/Header/swu_memberList.cpp.trc.h"
#endif 

using namespace std;

namespace swu {

   MemberListBase::~MemberListBase(){
      ETG_TRACE_ERR(("~MemberList, _bInitialized=%d",
                     _bInitialized));
      if (_bInitialized) {
         vDeInit();
      }
      vClear();
   }

      void MemberListBase::traceState(char const  *owner) {
      ETG_TRACE_COMP(("MemberList, _bInitialized=%d of=%s:traceState:",
                     _bInitialized, owner));

      for (deque<MemberBase *>::iterator iter = _members.begin();
            iter != _members.end(); ++iter) {
         MemberBase *member=*iter;
         if (OSAL_NULL != member) {
            // printf("%s: State\n", member->getName());
            ETG_TRACE_COMP(("%s: State:", member->getName()));
            member->traceState();
         }
      }
   }


   tVoid MemberListBase::vInit() {
     ETG_TRACE_USR2(("MemberList: vInit START"));
      for (deque<MemberBase *>::iterator iter = _members.begin();
            iter != _members.end(); ++iter) {
         if (OSAL_NULL != *iter) {
            //printf("MemberList: vInit call init of %s\n", (*iter)->getName());
	   ETG_TRACE_USR3(("MemberList: vInit (%s)", (*iter)->getName()));
            (*iter)->vInit();
         }
      }
      _bInitialized = TRUE;
      ETG_TRACE_USR2(("MemberList: vInit END"));
   }


   tVoid MemberListBase::vDeInit() {
     ETG_TRACE_USR2(("MemberList: vDeInit START"));
      for (deque<MemberBase *>::reverse_iterator iter = _members.rbegin();
            iter != _members.rend(); ++iter) {
         if (OSAL_NULL != *iter) {
	   ETG_TRACE_USR3(("MemberList: vDeInit (%p)", *iter));
            (*iter)->vDeInit();
         }
      }
      _bInitialized = FALSE;
      ETG_TRACE_USR2(("MemberList: vDeInit END"));

   }

   MemberBase * MemberListBase::addMember(MemberBase *pMember) {
     ETG_TRACE_USR2(("MemberList: poAdd(%p)", pMember));
      if (pMember) {
         _members.push_back(pMember);
         if (_bInitialized) {
            pMember->vInit();
         }
      }
      return pMember;
   }

   tVoid MemberListBase::removeMember(MemberBase *pMember) {
      for (deque<MemberBase *>::iterator iter = _members.begin();
            iter != _members.end(); ++iter) {
         if (pMember == *iter) {
            _members.erase(iter);
            break;
         }
      }
   }

tVoid MemberListBase::vClear() {
   for (deque<MemberBase *>::reverse_iterator iter = _members.rbegin();
        iter != _members.rend(); ++iter) {
      if (OSAL_NULL != *iter) {
         if (_bInitialized) {
            (*iter)->vDeInit();
         }
         OSAL_DELETE *iter;
      }
   }
   _members.clear();
}


tVoid MemberListBase::deleteMember_(MemberBase *pMember) {
   for (deque<MemberBase *>::iterator iter = _members.begin();
        iter != _members.end(); ++iter) {
      if (pMember == *iter) {
         if (_bInitialized) {
            (*iter)->vDeInit();
         }
         OSAL_DELETE pMember;
         _members.erase(iter);
         break;
      }
   }
}


}
