/*
 * swu_kvstore.hpp
 *
 *  Created on: Oct 17, 2013
 *      Author: efs1hi
 */

#ifndef SWU_KVSTORE_HPP_
#define SWU_KVSTORE_HPP_

#include <map>
#include <string>
#include <stdint.h>
#include <util/swu_xmlDoc.h>

class TiXmlElement;

namespace swu {

class KVStore {

public:
   KVStore(const std::string &filename);

   ~KVStore();

   void init();

   void trace();

   SWU_MOCK_VIRTUAL void sync() {
      _xmlFile.store();
   }

   TiXmlElement *getElem(const std::string &key) const;

   SWU_MOCK_VIRTUAL bool read(std::string const &key, std::string &val) const;
   SWU_MOCK_VIRTUAL bool read(std::string const &key, tU32 &val) const;
   SWU_MOCK_VIRTUAL bool read(std::string const &key, std::vector<tU8> &val) const;


   SWU_MOCK_VIRTUAL bool write(std::string const &key, std::string const &val);
   SWU_MOCK_VIRTUAL bool write(std::string const &key, tU32 const &val);
   SWU_MOCK_VIRTUAL bool write(std::string const &key, std::vector<tU8> const &val);



   SWU_MOCK_VIRTUAL bool containsKey(const std::string &key) const {
      return getElem(key);
   }

   SWU_MOCK_VIRTUAL void removeKey(const std::string &key);

private:
   static const std::string k_EMPTY_STRING;

   /**
    * Document holding the data
    */
   XmlFile _xmlFile;

   /**
    * Document holding the XML-Representation
    */
   TiXmlElement *_xmlRoot;

   /**
    * state
    */
   bool _initialized;
};

}

#endif
