#ifndef SWU_KDS_H
#define SWU_KDS_H



#include "util/swu_types.h"
#include "util/swu_configItem.hpp"


namespace swu {

struct KdsItemDescriptionBase;

struct TsKDSEntry;


typedef enum {
   enKsdEntryType_String,
   enKsdEntryType_UInt,
   enKsdEntryType_Data,
   enKsdEntryType_Invalid
} tenKsdEntryType;


class KdsDriver {

public:
   bool write(TsKDSEntry *kdsEntry);
   bool read(TsKDSEntry *kdsEntry);

private:
   bool open();
   void close();
   bool setWriteEnable(bool enable);

   OSAL_tIODescriptor _IOKdsHandle;
   bool _bWriteEnabled;

};


class KdsTable {
private:
   KdsTable & operator=(const KdsTable &);
   KdsTable(const KdsTable &);

public:
   KdsTable(tU16 key, tU16 len);
   KdsTable(KdsItemDescriptionBase const *item);
   virtual ~KdsTable();
   bool write(tU8 const *data, tU16 offset, tU16 len, bool doSync=true);
   bool read();
   tU32 getLen();
   bool getBytes(tU8 *data, tU16 offset, tU16 len);
   std::string getString(tU16 offset, tU16 len);

private:
   TsKDSEntry *_kdsEntry;
};


class Kds {
public:
   Kds(){}; 
   virtual ~Kds(){};

   virtual const char *getName() {
      return "Kds";
   }

   virtual void traceState(){};

   bool write(KdsItemDescriptionBase *item, tU32 val);
   bool write(KdsItemDescriptionBase *item, std::string const &val);
   bool write(KdsItemDescriptionBase *item, std::vector<tU8> const &val);
   bool read(KdsItemDescriptionBase *item, tU32 &val);
   bool read(KdsItemDescriptionBase *item, std::string &val);
   bool read(KdsItemDescriptionBase *item, std::vector<tU8> &val);
};

struct KdsItemDescriptionBase {
   KdsItemDescriptionBase(tU16 table, tU16 tableLen, tU16 offset, tU16 len, tenKsdEntryType type):
      _table(table),
      _tableLen(tableLen),
      _offset(offset),
      _len(len),
      _type(type)
   {}
   tU16 _table;
   tU16 _tableLen;
   tU16 _offset;
   tU16 _len;
   tenKsdEntryType _type;
   static tenKsdEntryType getKdsItemType(std::string *) { return enKsdEntryType_String;};
   static tenKsdEntryType getKdsItemType(tU32 *) { return enKsdEntryType_UInt;};
   static tenKsdEntryType getKdsItemType(std::vector<tU8> *) { return enKsdEntryType_Data;};
};

template<class VALTYPE>
struct KdsItemDescription: public ItemDescription<VALTYPE> {
   virtual bool read(VALTYPE &value) {
      Kds kds;
      return kds.read(&itemData, value);
   }

   virtual bool write(VALTYPE const &value) {
      Kds kds;
      return kds.write(&itemData, value);
   }

   virtual bool doSimulate() {
      return false; // todo peha
   }

   // kds syncs on every write
   void sync() {};
   KdsItemDescription(tU16 table, tU16 tableLen, tU16 offset, tU16 len, tenKsdEntryType type=KdsItemDescriptionBase::getKdsItemType((VALTYPE *)0)):
      itemData(table, tableLen, offset, len, type)
   {}
   KdsItemDescriptionBase itemData;
};

}

#endif

