#ifndef SWU_ISOCONTAINER_H_
#define SWU_ISOCONTAINER_H_

#include <errno.h>
#include <string>
#include <sstream>
#include <unistd.h>
#include <linux/loop.h>
#include <list>


namespace swu {


class IsoContainer {
public:
   IsoContainer(std::string mp):
      _deviceId(-1),
      _isMounted(false),
      _mp(mp),
      _srcOffset(0),  //Coverity fix for 98870
      _srcLen(0)
   {}

   IsoContainer(std::string mp, std::string srcFile, unsigned long long srcOffset=0, unsigned long long srcLen=0):
      _deviceId(-1),
      _isMounted(false),
      _mp(mp), 
      _srcFile(srcFile), 
      _srcOffset(srcOffset),
      _srcLen(srcLen)
   {

   }

   ~IsoContainer() {
      cleanup();
   }

   bool umount() {
      return cleanup();
   }
   bool cleanup();

   bool mount(std::string srcFile, unsigned long long srcOffset=0, unsigned long long srcLen=0);  
   bool mount();

   bool bindMount(std::string destDir);

   std::string getSrcFile() {
      return _srcFile;
   }

   std::string getMountPoint() {
      return _mp;
   }

   
   

private:




   std::string getLoopDeviceName();

   int _deviceId;
   bool _isMounted;
   std::string _mp;
   std::string _srcFile;
   unsigned long long _srcOffset;
   unsigned long long _srcLen;
};


/*
  expect config-file
  # (iso-file)                          directory where iso-file shall be mounted
  /var/opt/bosch/ota/dpIsoTest/dp.iso   /tmp/swupdate/isoChain/2
  /tmp/swupdate/isoChain/2/ivi.iso      /tmp/swupdate/isoChain/1
  /tmp/swupdate/isoChain/1/wcs.iso      /tmp/swupdate/isoChain/0
  # if last line is a plain file, it can be queried by getDataFile()
  /tmp/swupdate/isoChain/0/dataFile.tar

 */
class IsoContainerChain {
public:
   ~IsoContainerChain();
   bool mount(std::string configFile);

   bool store(std::string leafFile, std::string configFile);
   void umount();

   std::string getMountPoint();

   std::string getDataFile();

private:

   struct LoopDeviceInfo {
      std::string device;
      std::string container;
      std::string containerShort;
      tUInt offset;
      tUInt sizeLimit;
      LoopDeviceInfo():
         offset(0), 
         sizeLimit(0) {}
   };
   struct MountInfo {
      std::string device;
      std::string mp;
      std::string type;
      bool isBindMount;
      LoopDeviceInfo const *loopDeviceInfo;
      MountInfo():
         isBindMount(false),
         loopDeviceInfo(0)
      {}
   };

   void fetchLoopDeviceInfos(std::map<std::string, LoopDeviceInfo> &loopDeviceInfos);
   void fetchMountInfos(std::map<std::string, LoopDeviceInfo> &loopDeviceInfos,
                        std::map<std::string, MountInfo> &mountInfos);
   MountInfo const *getMountInfoByMp(std::string &mp, std::map<std::string, MountInfo> &mountInfos);
   std::string analyzeParentDir(std::string child, std::map<std::string, MountInfo> &mountInfos);
   std::list<swu::IsoContainer *> _containers;
   std::string _dataFile;

};


}

#endif
