#ifndef SWU_GLOBALLOG_HPP
#define SWU_GLOBALLOG_HPP


#include "util/swu_filesystem.h"
#include "util/swu_types.h"
#include "util/swu_trace.h"
#include "swu_util.hpp"


namespace swu {

#define __FILENAME__ (strrchr(__FILE__, '/') ? strrchr(__FILE__, '/') + 1 : __FILE__)

#define FAILURE_TOKEN_TEXT "SWU_FAILURE"
#define INTERFACE_TOKEN_TEXT "SWU_INTERFACE"
#define INFO_TOKEN_TEXT "SWU_INFO"

#define LOG_FAILURE(...) failureCallstack(__FILENAME__, __LINE__, __func__, __VA_ARGS__)
#define LOG_INTERFACE(...) interfaceCallstack(__FILENAME__, __LINE__, __func__, __VA_ARGS__)
#define LOG_GLOBALINFO(...) infoCallstack(__FILENAME__, __LINE__, __func__, __VA_ARGS__)

void failureCallstack(std::string fileName, int line, std::string functionName, char const* format,...);
void interfaceCallstack(std::string fileName, int line, std::string functionName, char const* format,...);
void infoCallstack(std::string fileName, int line, std::string functionName, char const* format,...);

class traceLog {

private:
   std::string _traceText;

public:
   traceLog(std::string fileName, int line, std::string functionName, std::string token, std::string text) {      
      _traceText = token + ": " + std::string(text) + " [ " + fileName + ":" + intToString(line) + " " + functionName + "() ]";
   }

   virtual ~traceLog() { 
   }

   void traceFatalLog() {      
      traceVarg(0, _traceText.c_str());
   }

   void traceErrMemLog() { 
      print2errmem(_traceText.c_str());
   }

   void traceConsoleLog() {
      traceConsole(_traceText.c_str());
   }

   void traceDownloadpipeLog() { 
      printToDownloadPipe(_traceText.c_str());
   }

};


}

#endif
