#ifndef SWU_FAC_UTIL_HPP
#define SWU_FAC_UTIL_HPP

/*
util for Flash Access Control for Linux
 */

#include <vector>
#include "swu_types.h"
#include "swu_crypto.hpp"

namespace swu {

#define FAC_DIRECTORY "/tmp/swupd/fac"

struct facInfo {
   
   tU32 _blockSize;
   tU32 _count;
   tU32 _skip;
   tU32 _seek;   
};


class facUtil {

public:
   facUtil();
   virtual ~facUtil();

   bool read(facInfo info, std::vector<tU32> &data);
   bool write(facInfo info, std::vector<tU32> data);
   bool erase(facInfo info);

private:
   bool prepareFac(facInfo &info);
   
};

}

#endif
