/**
 * @file       swu_cryptoFactory.hpp
 * @author     Philipp Blanke (blp4hi) <philipp.blanke@de.bosch.com>
 * @date       Fri 29 Jan 2016, 14:32
 * @copyright  Robert Bosch Car Multimedia GmbH
 * @brief      Factory which creates target key or CA certificate as described
 *             by swu::tenCertificateAndKeySource entries.
 *
 * @details    Usage example:
 * @code
      Config* cfg = Config::instance();
      CryptoFactory cf(cfg->cfg_CertificateAndKeySource.get());
      CTargetKeyIf* tkey = cf.createTargetKey();
      CACertIf*     cacert = cf.createCaCert();
   @endcode
 */

#ifndef SWU_CRYPTOFACTORY_HPP
#define SWU_CRYPTOFACTORY_HPP

#include "util/swu_crypto.hpp"
#include "util/swu_caCert.h"
#include "util/swu_targetKey.h"
#include "util/swu_uin.hpp"

namespace swu {
   
class CryptoFactory
{
   // Only allow Config constructor
   CryptoFactory();

public:
   CryptoFactory(tenCertificateAndKeySource src_type);
   ~CryptoFactory();

   CTargetKeyIf* createTargetKey () const;
   CACertIf*     createCaCert () const;
   UinIf*        createUin () const;

private:
   tenCertificateAndKeySource _src_type;
};
} /* namespace swu */

#endif
