/*
 * swu_constants.cpp
 *
 *  Created on: Feb 17, 2014
 *      Author: efs1hi
 */

#include "swu_constants.hpp"

namespace swu {
namespace Constants {
   
const uint8_t Ascii::CR = 0x0D;
const uint8_t Ascii::LF = 0x0A;

const ::std::string XML::update_decision__diff            = "DifferentOnly";
const ::std::string XML::update_decision__force           = "Any";
const ::std::string XML::update_decision__skip            = "Skip";
const ::std::string XML::update_decision__update          = "NewOnly";
const ::std::string XML::update_decision__updateNewOrSame = "NewAndSameOnly";
const ::std::string XML::update_decision__invalid         = "Invalid";

const ::std::string XML::update_progress_state__pending      = "pending";
const ::std::string XML::update_progress_state__running      = "running";
const ::std::string XML::update_progress_state__ok           = "ok";
const ::std::string XML::update_progress_state__failed       = "failed";
const ::std::string XML::update_progress_state__not_affected = "na";

const char*         XML::TAG_FINALNAME                       = "FINALNAME";
const char*         XML::TAG_FINALNAME_CUSTOMER              = "FINALNAME_CUSTOMER";
const char*         XML::TAG_BUILD_LABEL                     = "BUILD_LABEL";
const char*         XML::TAG_CISSWVERSIONNAME                = "CISSWVERSIONNAME";

const char*       Registry::REGISTRY_LABEL_ID         = "\"BUILDVERSION_LABEL\"=\"";
const char*       Registry::REGISTRY_VERSION_ID         = "\"BUILDVERSION_CUSTVERSTRING\"=\"";
const char*       Registry::REGISTRY_TIMESTAMP_ID     = "\"BUILDVERSION_TIMESTAMP\"=\"";
const std::string Registry::PATH_BASE                 = "/var/opt/bosch/persistent/registry";
const std::string Registry::PATH_CUSTOMER_VERSION_REG = Registry::PATH_BASE + "/customerversion.reg";
const std::string Registry::PATH_CUSTOMER_VERSION_CFG = Registry::PATH_BASE + "/customerversion_reg.cfg";
const mode_t      Registry::MODE_BASE                 = 0770;
const mode_t      Registry::MODE_CUSTOMER_VERSION_CFG = 0660;

const std::string Registry::PATH_OVERALL_CIS_SW_VERSION_REG = Registry::PATH_BASE + "/overallCISSWversion.reg";

const uid_t User::root = 0;
const uid_t User::eco_lcm = 7006;
const uid_t User::pj_nav = 15031;

const gid_t Group::root     = 0;
const gid_t Group::eco_osal = 7000;
const gid_t Group::pj_nav_share = 15032;

const std::string Cert::PEM_BEGIN_STR     = "-----BEGIN";
const char* Cert::PUBLIC_KEY_BEGIN_STR    = "-----BEGIN PUBLIC KEY-----";
const char* Cert::PUBLIC_KEY_END_STR      = "-----END PUBLIC KEY-----";
const char* Cert::CERTIFICATE_BEGIN_STR   = "-----BEGIN CERTIFICATE-----";
const char* Cert::CERTIFICATE_END_STR     = "-----END CERTIFICATE-----";
const char* Cert::DELIM_TERMINATING_STR   = "-----";
const char* Cert::MD_BEGIN_DELIM_STR      = "-----BEGIN SHA256 ";
const char* Cert::MD_END_DELIM_STR        = "-----END SHA256 ";
const char* Cert::SIGNED_MD_BEG_DELIM_STR = "-----BEGIN sha256WithRSAEncryption ";
const char* Cert::SIGNED_MD_END_DELIM_STR = "-----END sha256WithRSAEncryption ";
const char* Cert::ENCRYPT_PARAM_BEGIN_STR = "-----BEGIN DECRYPTION PARAMETERS-----";
const char* Cert::ENCRYPT_PARAM_END_STR   = "-----END DECRYPTION PARAMETERS-----";
const ::std::string Cert::MIME_STRING     = "MIME-Version: 1.0";

const char* Manifest::MANIFEST_ID = "MANIFEST";
const char* Manifest::SW_PN_ID = "SW PN ";
      
uint32_t const Mmc::MTD_RECOVERY_MAGIC_OFFSET = 0x00000020;
uint32_t const Mmc::MTD_RECOVERY_MAGIC_ACTIVE = 0x2342ABCD;
uint32_t const Mmc::MTD_RECOVERY_MAGIC_INACTIVE = 0xFFFFFFFF;

const char*    Mmc::MMC_WHOLE_DEVICE_NAME       = "/dev/mmcblk1";
const char*    Mmc::MTD0_DEVICE_NAME            = "/dev/mtd0";
const char*    Mmc::MTD0_BLOCK_DEVICE_NAME      = "/dev/mtdblock0";
const uint32_t Mmc::MTD_ERASED_MASK             = 0xFF;
const uint32_t Mmc::MTD_ZEROED_MASK             = 0x00;
const uint32_t Mmc::MTD_MAGIC_BUFFER_SIZE       = 128;
const uint32_t Mmc::MTD_MAGIC_CHAIN1_OFFSET     = 0x160000l;
const uint32_t Mmc::MTD_MAGIC_CHAIN2_OFFSET     = 0x180000l;
const uint32_t Mmc::MTD_CERTIFICATE_BUFFER_SIZE = 2048;
const uint32_t Mmc::MTD_CERTIFICATE1_OFFSET     = 0x1A0000l;
const uint32_t Mmc::MTD_CERTIFICATE2_OFFSET     = 0x1C0000l;
const uint32_t Mmc::VALID_MAGIC_VALUE           = 0xdeadbeefu;
const uint32_t Mmc::MTD_KEY_BUFFER_SIZE         = 4096;
const uint32_t Mmc::MTD_UIN_BUFFER_SIZE         = 0;
const uint32_t Mmc::MTD_TARGET_KEY1_OFFSET      = 0x1A2000l;
const uint32_t Mmc::MTD_TARGET_KEY2_OFFSET      = 0x1C2000l;
const uint32_t Mmc::MTD_TARGET_UIN1_OFFSET      = 0;
const uint32_t Mmc::MTD_TARGET_UIN2_OFFSET      = 0;
const uint32_t Mmc::USE_SECOND_BOOT_CHAIN       = 0x5aa501cb;
const uint32_t Mmc::SIZE_BOOT_CHAIN_REGISTRY    = 4096;
const uint32_t Mmc::OFFSET_BOOT_CHAIN1_REGISTRY = 8192;
const uint32_t Mmc::OFFSET_BOOT_CHAIN2_REGISTRY = (Mmc::OFFSET_BOOT_CHAIN1_REGISTRY + Mmc::SIZE_BOOT_CHAIN_REGISTRY);


uint32_t const RCAR::HYPERFLASH_RECOVERY_MAGIC_OFFSET = 0x00000020;
uint32_t const RCAR::HYPERFLASH_RECOVERY_MAGIC_ACTIVE = 0x2342ABCD;
uint32_t const RCAR::HYPERFLASH_RECOVERY_MAGIC_INACTIVE = 0xFFFFFFFF;
uint32_t const RCAR::HYPERFLASH_ROOTFS1_ACTIVE = 0xFFFFFFFF;
uint32_t const RCAR::HYPERFLASH_ROOTFS2_ACTIVE = 0x5AA501CB;


const char*    RCAR::MMC_WHOLE_DEVICE_NAME                       = "/dev/mmcblk1";
const uint32_t RCAR::HYPERFLASH_ERASED_MASK                      = 0xFF;
const uint32_t RCAR::HYPERFLASH_ZEROED_MASK                      = 0x00;
const uint32_t RCAR::HYPERFLASH_MAGIC_BUFFER_SIZE                = 0x40000l;

const uint32_t RCAR::HYPERFLASH_MAGIC_CHAIN1_OFFSET              = 0x180000l;
const uint32_t RCAR::HYPERFLASH_MAGIC_CHAIN1_COUNTER_ADDR        = 0x180010l;
const uint32_t RCAR::HYPERFLASH_MAGIC_CHAIN1_STATUS_ADDR         = 0x180020l;
const uint32_t RCAR::HYPERFLASH_MAGIC_CHAIN1_ETHERNET_ADDR       = 0x180030l;
const uint32_t RCAR::HYPERFLASH_MAGIC_CHAIN1_ROOTFS_ADDR         = 0x180040l;
const uint32_t RCAR::HYPERFLASH_MAGIC_CHAIN2_OFFSET              = 0x1C0000l;
const uint32_t RCAR::HYPERFLASH_MAGIC_CHAIN2_COUNTER_ADDR        = 0x1C0010l;
const uint32_t RCAR::HYPERFLASH_MAGIC_CHAIN2_STATUS_ADDR         = 0x1C0020l;
const uint32_t RCAR::HYPERFLASH_MAGIC_CHAIN2_ETHERNET_ADDR       = 0x1C0030l;
const uint32_t RCAR::HYPERFLASH_MAGIC_CHAIN2_ROOTFS_ADDR         = 0x1C0040l;

const uint32_t RCAR::HYPERFLASH_CERTIFICATE_BUFFER_SIZE          = 2048;
const uint32_t RCAR::HYPERFLASH_CERTIFICATE1_OFFSET              = 0x1A0000l;
const uint32_t RCAR::HYPERFLASH_CERTIFICATE2_OFFSET              = 0x1C0000l;
const uint32_t RCAR::INVALID_MAGIC_VALUE                         = 0xFFFFFFFF;
const uint32_t RCAR::VALID_MAGIC_VALUE                           = 0xdeadbeefu;
const uint32_t RCAR::HYPERFLASH_KEY_BUFFER_SIZE                  = 4096;
const uint32_t RCAR::HYPERFLASH_UIN_BUFFER_SIZE                  = 0;
const uint32_t RCAR::HYPERFLASH_TARGET_KEY1_OFFSET               = 0x1A2000l;
const uint32_t RCAR::HYPERFLASH_TARGET_KEY2_OFFSET               = 0x1C2000l;
const uint32_t RCAR::HYPERFLASH_TARGET_UIN1_OFFSET               = 0;
const uint32_t RCAR::HYPERFLASH_TARGET_UIN2_OFFSET               = 0;
const uint32_t RCAR::USE_SECOND_BOOT_CHAIN                       = 0x5aa501cb;
const uint32_t RCAR::SIZE_BOOT_CHAIN_REGISTRY                    = 4096;
const uint32_t RCAR::OFFSET_BOOT_CHAIN1_REGISTRY                 = 8192;
const uint32_t RCAR::OFFSET_BOOT_CHAIN2_REGISTRY        = (RCAR::OFFSET_BOOT_CHAIN1_REGISTRY + RCAR::SIZE_BOOT_CHAIN_REGISTRY);




// Paths to SDC encrypted files
const char* SDC::PATH_UIN     = "/var/opt/bosch/persistent/id/uin.wrap";
const char* SDC::PATH_PRIVKEY = "/var/opt/bosch/persistent/id/privkey.pem.wrap";
const char* SDC::PATH_PUBKEY  = "/var/opt/bosch/persistent/id/pubkey.pem.wrap";
const char* SDC::PATH_BIKEY  = "/var/opt/bosch/persistent/certs/swu_alliance.pub.bin.wrap"; 
const char* SDC::PATH_CACERT  = "/var/opt/bosch/persistent/certs/cacert.pem.wrap";

const char* SDC::PSA_PATH_PRIVKEY = "/var/opt/bosch/persistent/id/RCC-privkey.pem.wrap";
const char* SDC::PSA_PATH_PUBKEY  = "/var/opt/bosch/persistent/id/RCC-pubkey.pem.wrap";
const char* SDC::PSA_PATH_CACERT  = "/var/opt/bosch/persistent/certs/PSA-OVIP-G1.crt.wrap";
} // ns Constants
} // ns swu
