#include "asf/core/BaseComponent.h"
#include "asf/core/Logger.h"
#include "asf/core/Proxy.h"
#include <map>


#include "util/swu_types.h"
#include "util/swu_asfUtil.hpp"

#include "util/swu_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_UTIL
#include "trcGenProj/Header/swu_asfUtil.cpp.trc.h"
#endif

using namespace std;

namespace swu {


void ProxyAccessBase::init(string port)  {
   ETG_TRACE_USR4(("ProxyAccessBase init(%s)", port.c_str()));
   if (_port.empty()) {
     _port=port;
     getProxyBase();
   } else {
     ETG_TRACE_USR4(("ProxyAccessBase init(%s): already initialized", port.c_str()));

   }
}


void ProxyAccessBase::traceCreateProxy() {
   ETG_TRACE_USR4(("ProxyAccess getProxy: CREATE(%s)", _port.c_str()));

}


void ProxyList::registerProxy(string port, ProxyAccessBase *proxy) {
   ETG_TRACE_USR4(("ProxyList::registerProxy(%08x:%s)", proxy, port.c_str()));
   _proxies[port]=proxy;
};

// get proxy by port
boost::shared_ptr<asf::core::Proxy> ProxyList::getProxy(string port) {
   boost::shared_ptr<asf::core::Proxy> res;

   map<std::string, ProxyAccessBase *>::iterator iter=_proxies.find(port);
   if (iter!=_proxies.end()) {
      ETG_TRACE_USR4(("ProxyList::getProxy(port=%20s ptr=%08x): FOUND, ", port.c_str(), &(*(iter->second->getProxyBase()))));
      return iter->second->getProxyBase();
   };
   ETG_TRACE_USR4(("ProxyList::getProxy(%s): NOT FOUND, ", port.c_str()));
   return res;
};


// find proxy in list and broadcast message Msg_ProxyAvailability<PROXY>(avail)
void ProxyList::onAvail(boost::shared_ptr<asf::core::Proxy> proxy, bool avail) {
  printf("ProxyList::onAvail: looking for proxy\n");
   for (map<std::string, ProxyAccessBase *>::iterator iter=_proxies.begin();
        iter != _proxies.end(); ++iter) {
      ProxyAccessBase *access=iter->second;
      if (access->getProxyBase() ==proxy) {
         ETG_TRACE_USR4(("ProxyList::onAvail(avail=%u, ptr=%p): proxy=%s", avail, &(*proxy), access->getPortName().c_str()));
	 printf("ProxyList::onAvail(avail=%u): proxy=%s\n", avail, access->getPortName().c_str());
         access->notifyAvail(avail);
         return;
      }
   };
   printf("ProxyList::onAvail: Proxy not found\n");
   ETG_TRACE_USR4(("ProxyList::onAvail(avail=%u, ptr=%p): proxy not found", avail, &(*proxy)));
}

void AsfTraceHelper::traceAsfMsgName(tUInt traceClass, tUInt traceLevel, string const &name, string const& line) {
   if (name.size()) {
      ETG_TRACE_LVL_CLS_DCL((traceLevel, TR_CLASS_SWUPDATE_UTIL, traceClass, "%s:", name.c_str()));
   }
   ETG_TRACE_LVL_CLS_DCL((traceLevel, TR_CLASS_SWUPDATE_UTIL, traceClass, "%s:", line.c_str()));
}

void AsfTraceHelper::traceSendResult(char const *method, act_t storedAct, bool bOk) {
   ETG_TRACE_COMP(("SendResult: send%20sResult storedAct=%u, bOk=%u",
                   method, storedAct, bOk));
}

void AsfTraceHelper::traceAct(const char *action, act_t act) {
   ETG_TRACE_COMP(("AsfReqActHolder::%5s():_act=%u", action, act));
}


}



