#ifndef SWU_HYPERFLASH_BOOTCHAINMGR_H_
#define SWU_HYPERFLASH_BOOTCHAINMGR_H_

#include "swu_BootChainMgr.h"
#include <string>

namespace swu {

// Magic sector 1
#define DL_MAGIC_SECTOR_VALID_FLAG_HYPERFLASH        0x00180000
#define DL_MAGIC_SECTOR_COUNTER_FLAG_HYPERFLASH      0x00180010
#define DL_UPDATE_STATUS_FLAG_HYPERFLASH             0x00180020
#define DL_ETHERNET_FLAG_HYPERFLASH                  0x00180030
#define DL_ROOTFS_FLAG_HYPERFLASH                    0x00180040


// Magic sector 2
#define DL_MAGIC_SECTOR_VALID_FLAG_2_HYPERFLASH     0x001C0000
#define DL_MAGIC_SECTOR_COUNTER_FLAG_2_HYPERFLASH   0x001C0010
#define DL_UPDATE_STATUS_FLAG_2_HYPERFLASH          0x001C0020
#define DL_ETHERNET_FLAG_2_HYPERFLASH               0x001C0030
#define DL_ROOTFS_FLAG_2_HYPERFLASH                 0x001C0040

// Values
#define DL_UPDATE_STATE_SUCCESS_HYPERFLASH          0xFFFFFFFF // Normal operation (default)
#define DL_UPDATE_STATE_FAILURE_HYPERFLASH          0x2342ABCD // Recovery-Download-Mode
#define DL_UPDATE_STATE_RECOVERY_HYPERFLASH         0x2342ABCD // Recovery-Download-Mode
#define DL_MAGIC_SECTOR_VALID_HYPERFLASH            0xDEADBEEF // Sector OK
#define DL_MAGIC_SECTOR_INVALID_HYPERFLASH          0xFFFFFFFF // Sector invalid
#define DL_ROOTFS_1_HYPERFLASH                      0xFFFFFFFF // Boot chain 1 (default)
#define DL_ROOTFS_2_HYPERFLASH                      0x5AA501CB // Boot chain 2

// Misc
#define DNL_MAGIC_ARRAY_SIZE_HYPERFLASH               (5 * 4)           // 20 DWORDs
#define DNL_MAGIC_AREA_SIZE_HYPERFLASH                (DNL_MAGIC_ARRAY_SIZE_HYPERFLASH * 4)  // 80 Bytes
#define DNL_MAGIC1_BASE_ADDRESS_HYPERFLASH            DL_MAGIC_SECTOR_VALID_FLAG_HYPERFLASH
#define DNL_MAGIC2_BASE_ADDRESS_HYPERFLASH            DL_MAGIC_SECTOR_VALID_FLAG_2_HYPERFLASH
#define DL_UPDATE_STATUS_FLAG_OFFSET_HYPERFLASH       (DL_UPDATE_STATUS_FLAG_HYPERFLASH - DNL_MAGIC1_BASE_ADDRESS_HYPERFLASH)
#define DL_ETHERNET_FLAG_OFFSET_HYPERFLASH            (DL_ETHERNET_FLAG_HYPERFLASH      - DNL_MAGIC1_BASE_ADDRESS_HYPERFLASH)
#define DL_ROOTFS_FLAG_OFFSET_HYPERFLASH              (DL_ROOTFS_FLAG_HYPERFLASH        - DNL_MAGIC1_BASE_ADDRESS_HYPERFLASH)

//DECIMAL
#define DL_MAGIC_SECTOR_VALID_FLAG_HYPERFLASH_DECIMAL        1572864  //0x00180000 in decimal
#define DL_MAGIC_SECTOR_VALID_FLAG_2_HYPERFLASH_DECIMAL      1835008  //0x001C0000 in decimal

//String
#define BlOCK_SIZE_HYPERFLASH                                "1024"
#define COUNT_HYPERFLASH                                     "256"
#define FAC_FILE_TO_WRITE_HYPERFLASH                         "/tmp/InputFile"
#define FAC_FILE_TO_READ_HYPERFLASH                          "/tmp/OutputFile"
#define BLOCK_SIZE_STRING                                    " bs="
#define COUNT_STRING                                         " count="
#define SEEK_STRING                                          " seek="
#define SKIP_STRING                                          " skip="
#define FAC_WRITE_COMMAND_HYPERFLASH                         "./fac_out.out of=SCCFLASH if="
#define FAC_READ_COMMAND_HYPERFLASH                          "./fac_out.out if=SCCFLASH of="
#define FAC_ERASE_COMMAND_HYPERFLASH                         "./fac_out.out erase " BLOCK_SIZE_STRING

/**
 * Manager class for boot chains.
 * @todo add legacy functionality to this class in order to provide an integrate approach to modify boot chain control data.
 */

class swu_HyperFlashBootChain : public RawFlashBootChainMgr
{
public:

    virtual ~swu_HyperFlashBootChain();

    static swu_HyperFlashBootChain* Instance();
    /**
     * Activates the recovery mode for the active boot chain.
     * @return true for success, else false
     */
    const bool activateRecoveryMode();


    /**
     * Activates the application mode for the active boot chain.
     * @return true for success, else false
     */
    const bool activateApplicationMode();

    /**
     * Switch the active boot chain to One.
     * @return true for success, else false
     */
    const bool switchBootChainOne();

    /**
     * Switch the active boot chain to Two.
     * @return true for success, else false
     */
    const bool switchBootChainTwo();

    //@todo: activateBootChain(param BC1, BC2);
    //@todo: BC1 or BC2 activeBootchain();

    int  readFromFac(off_t u32FlashAdress ,tPU32 pu32FlashMagicArea);

    int  writeToFac(const tU8 *pu8BufferPointer,off_t inDestinationOffset,bool flag);

    void  EraseFac(int inDestinationOffset,bool flag);

    bool bWriteMagicToRawFlash (unsigned int u32FlashMagicOffset, unsigned int u32Value);

    bool bReadMagicFromRawFlash (const unsigned int inFlashAddress, unsigned int& outValue);

    bool bWriteMagicBootChain (const unsigned int inFlashAddress, const unsigned int inValue);

    bool bReadFlagFromRawFlash (off_t u32FlashAdress, tPU32 pu32Value);

    bool bReadMagicAreas (tU32  u32FlashMagicOffset, tPU32 pu32MagicIndex, tPU32 pu32FlashMagicArea1, tPU32 pu32FlashMagicArea2, tPU32 pu32MagicAreaSelected);

    bool isRecoveryMagicSet(bool &isSet);

    bool usedBootChain(int &chain);

    bool areaSelected(int &MagicAreaSelected);

    bool usedBootChain() {
        int res=1;
        usedBootChain(res);
        return res;
   }

    bool isRecoveryMagicSet() {
        bool isSet=false;
        isRecoveryMagicSet(isSet);
        return isSet;
   }

private:
    swu_HyperFlashBootChain();  // Private so that it can  not be called
    swu_HyperFlashBootChain(swu_HyperFlashBootChain const&);             // copy constructor is private
    swu_HyperFlashBootChain& operator=(swu_HyperFlashBootChain const&);  // assignment operator is private
    static swu_HyperFlashBootChain* m_pInstance;
    int retNoOfBytesToSkip(off_t starting_address);
    std::string block_size;
    std::string count;
};

}
#endif
