/************************************************************************
* File: teseo_SWBinaryHandler.h
* SW-Component: 
*
* Description:
*	Provides interfaces for reading the teseo binary files
*				and calculate CRC32 for the teseo firmware.
*				CRC is calculated first over the length of the file and then
*				over the entire file. 
* Author:
*   Rohit.ChannappiahRaman@in.bosch.com
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 14.10.2013 - Initial version - Rohit.ChannappiahRaman@in.bosch.com
* 27.08.2013 - Implemented CMG3G-5318 optimized logging using update.log - Apoorva K R (RBEI/ECA1)
 * 6/4/2015 - Implemented CMG3G-6728 IS2030_Teseo update only if CRC changed@Integration Tooling - Apoorva K.R (RBEI/ECA1)
 *---------------------------------------------------------------------------------------------------
* 1/2/2016          | AGL5KOR (RBEI)    |     CMG3G-9450 - teseo update ctrl app to be modified to write and read CRC
* 				    | Anusha Ghali	    | 
*---------------------------------------------------------------------------------------------------
***********************************************************************/
#ifndef _TESEO_SW_BINARY_HANDLER_H_
#define _TESEO_SW_BINARY_HANDLER_H_

#include <string>
#include <stdio.h>
#include "ai_osal_linux/components/system/system_types.h"
#include "UpdateLog.h"

using namespace ::ai_sw_update::common;

class teseo_SWBinaryHandler {
public:
	teseo_SWBinaryHandler();
	virtual ~teseo_SWBinaryHandler();
	
	tBool bOpenFile(std::string& strFilePath);
	tBool bCloseFile();
	tBool bCalcCRC32(tU32& crc,std::string& strFilePath);
	tBool bCalcCRCFlasher32(tU32 &u32Crc,std::string& strFilePath);
	tBool bReadFile(tU32 u32BytesToRead, tU8* buff, tS32& u32BytesRead);
	tS32 s32GetFileSize() const;
	std::string s32GetFileName() const;
	tBool bCalcCRC32ForFixedSize (tU32 &u32Crc, std::string& strFilePath);
	tU32 u32EtherCrc32Accumulate(tU32 u32Crc32val, const tU8* pu8Buff, tU32 len) const;
	
private:
    // Private methods
	tBool u32CalcFileSize();
	
	tS32 m_s32FileSize;
	std::string m_strFileName;
	FILE* m_pFile;
	teseo_SWBinaryHandler ( const teseo_SWBinaryHandler & );  //COverity fix for 48139
	teseo_SWBinaryHandler & operator = ( const teseo_SWBinaryHandler & ); //Coverity fix for 47698
};

#endif //_TESEO_SW_BINARY_HANDLER_H_
