/************************************************************************
 * FILE: 			sxm_version_utility.h
 *
 * SW-COMPONENT: 	swu_common_sxm_lib
 *
 * DESCRIPTION: 	Interfaces for SXM version related queries
 *
 * AUTHOR: 			Logesh Gopalakrishnan (RBEI/ECA)
 *
 * COPYRIGHT: 		(c) Robert Bosch Engineering and Business Solutions Ltd.
 *
 * HISTORY:
 * 	04.12.2015 	Rev. 1.0 Logesh
 * 				Initial Revision.
 *  20.06.2016  Rev. 1.1 Logesh
 * 				Choose firmware from a dir based on HType.
************************************************************************/

// TODO: check how to unit test this

#ifndef _SXM_VERSION_UTILITY_H_
#define _SXM_VERSION_UTILITY_H_


#include "sxm_sms_api_patch.h"
#include <string>
#include "sxm_types.h"

namespace SiriusModuleUpdateControlLib {


class SXM_VersionUtility
 {

 public:

	SXM_VersionUtility();

	virtual ~SXM_VersionUtility();

	virtual tVoid getSoftwareVersionOfModule(MODULE_OBJECT hModule, std::string &SwVersion)=0;
	virtual tVoid getHardwareVersionOfModule(MODULE_OBJECT hModule, std::string &SwVersion)=0;
	virtual tVoid getHardwareTypeOfModule(MODULE_OBJECT hModule, std::string &SwVersion)=0;
	virtual tVoid getSerialVersionOfModule(MODULE_OBJECT hModule, std::string &SwVersion)=0;
	virtual tVoid getSoftwareVersionOfFirmware(std::string FirmwareFilePath, std::string &firmwareFileVersion)=0;
	virtual tVoid getHardwareTypeFromFirmware(std::string FirmwareFilePath, std::string &FirmwareHardwareType)=0;
	virtual tVoid getDetailsOfFirmware(std::string FirmwareFilePath, std::string &FirmwareFileVersion, 
		std::string &FirmwareHardwareType, std::string &EarliestVersion, std::string &LatestVersion)=0;
 };
 
class tclSXM_VersionUtility : public SXM_VersionUtility
{

private:
	tVoid vCopySmsString2Stl(STRING_OBJECT hSmsStringObj, std::string &rStlString);
public:
	tclSXM_VersionUtility();
	virtual ~tclSXM_VersionUtility();

	tVoid getSoftwareVersionOfModule(MODULE_OBJECT hModule, std::string &SwVersion);
	tVoid getSoftwareVersionOfFirmware(std::string FirmwareFilePath, std::string &firmwareFileVersion);
	tVoid getHardwareTypeOfModule(MODULE_OBJECT hModule, std::string &SwVersion);
	tVoid getHardwareVersionOfModule(MODULE_OBJECT hModule, std::string &SwVersion);
	tVoid getSerialVersionOfModule(MODULE_OBJECT hModule, std::string &SwVersion);
	tVoid getHardwareTypeFromFirmware(std::string FirmwareFilePath, std::string &FirmwareHardwareType);
	tVoid getDetailsOfFirmware(std::string FirmwareFilePath, std::string &FirmwareFileVersion, 
		std::string &FirmwareHardwareType, std::string &EarliestVersion, std::string &LatestVersion);
};
 
} // namespace SiriusModuleUpdateControlLib


#endif // _SXM_VERSION_UTILITY_H_
