/************************************************************************
 * FILE: 			sxm_version_utility.cpp
 *
 * SW-COMPONENT: 	swu_common_sxm_lib
 *
 * DESCRIPTION: 	Staic Implementations for SXM version related queries
 *
 * AUTHOR: 			Logesh Gopalakrishnan (RBEI/ECA)
 *
 * COPYRIGHT: 		(c) Robert Bosch Engineering and Business Solutions Ltd.
 *
 * HISTORY:
 * 	04.12.2015 	Rev. 1.0 Logesh
 * 				Initial Revision.
 *  20.06.2016  Rev. 1.1 Logesh
 * 				Choose firmware from a dir based on HType.
************************************************************************/


#include "sxm_version_utility.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
	#define ETG_I_TRACE_CHANNEL 			TR_TTFIS_SWUPDATE_CTRL
	#define ETG_I_TTFIS_CMD_PREFIX 			"DNL_"
	#define ETG_I_FILE_PREFIX 				dl_tclSXM::
    #define ETG_DEFAULT_TRACE_CLASS 		TR_CLASS_SWUPDATE_SXM
  #include "trcGenProj/Header/sxm_version_utility.cpp.trc.h"
#endif
#include "ai_sw_update/common/base/imp/swupd_trace.h"


using namespace SiriusModuleUpdateControlLib;
using namespace std;

SXM_VersionUtility::SXM_VersionUtility() {}
SXM_VersionUtility::~SXM_VersionUtility() {}


/************************************************************************
 * FUNCTION: tclSXM_VersionUtility::tclSXM_VersionUtility
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 *
 * RETURNVALUE:
 *
 * HISTORY:
 * 	04.12.2015 	Rev. 1.0 Logesh
 * 				Initial Revision.
************************************************************************/
tclSXM_VersionUtility::tclSXM_VersionUtility()
{

}

/************************************************************************
 * FUNCTION: tclSXM_VersionUtility::~tclSXM_VersionUtility
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 *
 * RETURNVALUE:
 *
 * HISTORY:
 * 	04.12.2015 	Rev. 1.0 Logesh
 * 				Initial Revision.
************************************************************************/
tclSXM_VersionUtility::~tclSXM_VersionUtility()
{
}

/************************************************************************
 * FUNCTION: tclSXM_VersionUtility::vCopySmsString2Stl
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 * 				STRING_OBJECT, string&
 *
 * RETURNVALUE: void
 *
 * HISTORY:
 * 	04.12.2015 	Rev. 1.0 Logesh
 * 				Initial Revision.
************************************************************************/
tVoid tclSXM_VersionUtility::vCopySmsString2Stl(STRING_OBJECT hSmsStringObj, string &rStlString) {
	char string_buffer[50 + 1];
	char *pBufNew = NULL;
	char *pBuf = string_buffer;

	/*The length excluding the string Terminator */
	tUInt u32MaxLen = (STRING.tSize(hSmsStringObj)) + 1;
	if (u32MaxLen < 1) {
		rStlString = "";
		return;
	}

	/*Checking for size 0.If 0, providing max length value to
	 tCopyToCStr() so that the function will ensure a NULL
	 termination to the destination string
	 Condition to put null terminator for tCopyToCStr(): valid
	 destination pointer and a non-zero size */
	/*if (!u32MaxLen) {
	 u32MaxLen=FC_SXM_DEFAUL_SMS_STRING_LEN;
	 }*/
	if (u32MaxLen > 50) {
		if (u32MaxLen > 1000) {
			u32MaxLen = 1000;
		}
		pBufNew = new char[u32MaxLen + 1];
		pBuf = pBufNew;
	}

	if (NULL != pBuf) {
		pBuf[0] = 0;
		STRING.tCopyToCStr(hSmsStringObj, pBuf, u32MaxLen);
		rStlString = pBuf;
	}

	if (NULL != pBufNew) {
		delete[] pBufNew;
	}
}

/************************************************************************
 * FUNCTION: tclSXM_VersionUtility::getSoftwareVersionOfModule
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 * 				MODULE_OBJECT, string&
 *
 * RETURNVALUE: void
 *
 * HISTORY:
 * 	04.12.2015 	Rev. 1.0 Logesh
 * 				Initial Revision.
************************************************************************/
tVoid tclSXM_VersionUtility::getSoftwareVersionOfModule(MODULE_OBJECT hModule, string &version) {
	vCopySmsString2Stl(MODULE_VERSION.hSoftwareRevision(hModule), version);
}
/************************************************************************
 * FUNCTION: tclSXM_VersionUtility::getHardwareVersionOfModule
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 * 				MODULE_OBJECT, string&
 *
 * RETURNVALUE: void
 *
 * HISTORY:
 * 	04.12.2015 	Rev. 1.0 Logesh
 * 				Initial Revision.
************************************************************************/
tVoid tclSXM_VersionUtility::getHardwareVersionOfModule(MODULE_OBJECT hModule, string &version) {
	vCopySmsString2Stl(MODULE_VERSION.hHardwareRevision(hModule), version);
}
/************************************************************************
 * FUNCTION: tclSXM_VersionUtility::getHardwareTypeOfModule
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 * 				MODULE_OBJECT, string&
 *
 * RETURNVALUE: void
 *
 * HISTORY:
 * 	20.06.2016 	Rev. 1.0 Logesh
 * 				Initial Revision.
************************************************************************/
tVoid tclSXM_VersionUtility::getHardwareTypeOfModule(MODULE_OBJECT hModule, string &version) {
	vCopySmsString2Stl(MODULE_VERSION.hTypeID(hModule), version);
}
/************************************************************************
 * FUNCTION: tclSXM_VersionUtility::getSerialVersionOfModule
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 * 				MODULE_OBJECT, string&
 *
 * RETURNVALUE: void
 *
 * HISTORY:
 * 	04.12.2015 	Rev. 1.0 Logesh
 * 				Initial Revision.
************************************************************************/
tVoid tclSXM_VersionUtility::getSerialVersionOfModule(MODULE_OBJECT hModule, string &version) {
	vCopySmsString2Stl(MODULE.hESN(hModule), version);
}

/************************************************************************
 * FUNCTION: tclSXM_VersionUtility::getDetailsOfFirmware
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 * 				string, string&, string&, string&, string&
 *
 * RETURNVALUE: void
 *
 * HISTORY:
 * 	20.06.2016 	Rev. 1.0 Logesh
 * 				Initial Revision.
************************************************************************/
tVoid tclSXM_VersionUtility::getDetailsOfFirmware(string firmwareFilePath,
		string &firmwareFileVersion,
		string &firmwareHardwareType,
		string &earliestVersion,
		string &latestVersion) {
	STRING_OBJECT hFileVersion, hFileEarliestVersion, hFileLatestVersion,
			hFileTypeID; //create emptry strings because the API specifies caller allocated strings

	hFileVersion = STRING.hCreate("", 1);
	hFileEarliestVersion = STRING.hCreate("", 1);
	hFileLatestVersion = STRING.hCreate("", 1);
	hFileTypeID = STRING.hCreate("", 1);

	if ((hFileVersion != STRING_INVALID_OBJECT )
			&& (hFileEarliestVersion != STRING_INVALID_OBJECT )
			&& (hFileLatestVersion != STRING_INVALID_OBJECT )
			&& (hFileTypeID != STRING_INVALID_OBJECT )) {

		SMSAPI_RETURN_CODE_ENUM eReturnCode;
		eReturnCode = MODULE_VERSION.eFWUpdateFileVersion(firmwareFilePath.c_str(),
				hFileVersion, hFileEarliestVersion, hFileLatestVersion,
				hFileTypeID);

		vCopySmsString2Stl(hFileVersion, firmwareFileVersion);
		vCopySmsString2Stl(hFileTypeID, firmwareHardwareType);
		vCopySmsString2Stl(hFileEarliestVersion, earliestVersion);
		vCopySmsString2Stl(hFileLatestVersion, latestVersion);

		if (eReturnCode != SMSAPI_RETURN_CODE_SUCCESS)
		{
			ETG_TRACE_USR4(("Firmware file version error: %d", eReturnCode));
		}


		STRING.vDestroy(hFileVersion);
		STRING.vDestroy(hFileEarliestVersion);
		STRING.vDestroy(hFileLatestVersion);
		STRING.vDestroy(hFileTypeID);
	}
}

/************************************************************************
 * FUNCTION: tclSXM_VersionUtility::getSoftwareVersionOfFirmware
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 * 				string, string&
 *
 * RETURNVALUE: void
 *
 * HISTORY:
 * 	20.06.2016 	Rev. 1.0 Logesh
 * 				Initial Revision.
************************************************************************/
tVoid tclSXM_VersionUtility::getSoftwareVersionOfFirmware(string firmwareFilePath, string &firmwareFileVersion) {
	string dummy = string();
	getDetailsOfFirmware(firmwareFilePath, firmwareFileVersion, dummy, dummy, dummy);
}

/************************************************************************
 * FUNCTION: tclSXM_VersionUtility::getHardwareTypeOfFirmware
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 * 				string, string&
 *
 * RETURNVALUE: void
 *
 * HISTORY:
 * 	20.06.2016 	Rev. 1.0 Logesh
 * 				Initial Revision.
************************************************************************/
tVoid tclSXM_VersionUtility::getHardwareTypeFromFirmware(string firmwareFilePath, string &firmwareHardwareType) {
	string dummy = string();
	getDetailsOfFirmware(firmwareFilePath, dummy, firmwareHardwareType, dummy, dummy);
}
