/************************************************************************
 * FILE: 			sxm_update_log.h
 *
 * SW-COMPONENT: 	swu_common_sxm_lib
 *
 * DESCRIPTION: 	Macro for Update Log and console log for easy readability
 *
 * AUTHOR: 			Logesh Gopalakrishnan (RBEI/ECA)
 *
 * COPYRIGHT: 		(c) Robert Bosch Engineering and Business Solutions Ltd.
 *
 * HISTORY:
 * 	04.12.2015 	Rev. 1.0 Logesh
 * 				Initial Revision.
************************************************************************/

#ifndef _SXM_UPDATE_LOG_H_
#define _SXM_UPDATE_LOG_H_

#include "UpdateLog.h"

extern tBool bLoggingEnabled;

#define UpdateLogInfo(format, args...) \
	UpdateLog::vUpdateLogTrace("%s "format"",DL_LOG_INFO,##args); \
	if(bLoggingEnabled) fprintf(stderr, ""format"\n",##args);


#define UpdateLogError(format,args...) \
	UpdateLog::vUpdateLogTrace("%s " format "",DL_LOG_ERROR,##args); \
	if(bLoggingEnabled) fprintf(stderr, ""format"\n",##args);


#endif // _SXM_UPDATE_LOG_H_
