/************************************************************************
 * FILE: 			sxm_module_handler.h
 *
 * SW-COMPONENT: 	swu_common_sxm_lib
 *
 * DESCRIPTION: 	A wrapper class implementation for sms-lib,
 * 					to provide update interfaces
 *
 * AUTHOR: 			Logesh Gopalakrishnan (RBEI/ECA)
 *
 * COPYRIGHT: 		(c) Robert Bosch Engineering and Business Solutions Ltd.
 *
 * HISTORY:
 * 	04.12.2015 	Rev. 1.0 Logesh
 * 				Initial Revision.
 *  20.06.2016  Rev. 1.1 Logesh
 * 				Choose firmware from a dir based on HType.
************************************************************************/


#ifndef _SXM_MODULE_HANDLER_H_
#define _SXM_MODULE_HANDLER_H_


#include "sxm_enums.h"
#include "sxm_singleton.h"
#include "sxm_types.h"
#include "sxm_sms_api_patch.h"
#include <pthread.h>
#include <string>

extern "C" void SRH_vRegisterDriver(char* pacUARTConfig);
extern "C" void SRH_vUnRegisterDriver( void );

extern const OSAL_DEV_INTERFACE_STRUCT GsPosixSerialInterface;
extern const OSAL_DEV_INTERFACE_STRUCT GsSioInterface;


namespace SiriusModuleUpdateControlLib {


typedef tVoid (*cbProgressInformation) (tU8);

class SiriusModuleHandler : public Singleton<SiriusModuleHandler>{

	friend class Singleton<SiriusModuleHandler>;

private:
	SRM_OBJECT _hSRM;
	MODULE_OBJECT _hModule;

	class SXM_GPIO* oGPIO;
	class SXM_VersionUtility* oVersionUtility;

	cbProgressInformation _cbProgressUpdate;
	MODULE_ERROR_CODE_ENUM enModuleErrorCode;
	SXM_ERROR_CODE_ENUM enUpdateErrorCode;

	tBool isDriverReady, isSRMReady, isModuleReady;
	SXM_STATE_ENUM enUpdateState;

	std::string serialVersion, hardwareVersion, hardwareType, softwareVersion,
		firmwareFileVersion, firmwareHardwareType, firmwareFilePath;

	pthread_mutex_t DriverReadyMutex, SRMReadyMutex, ModuleReadyMutex, UpdateCompleteMutex;

	pthread_cond_t DriverReadyCondition, SRMReadyCondition, ModuleReadyCondition, UpdateCompleteCondition;

	int resetCounter;

	SiriusModuleHandler();
	SiriusModuleHandler(const SiriusModuleHandler&);
	SiriusModuleHandler& operator=(const SiriusModuleHandler&);

	static tBool bRegisterDrivers(tVoid *pvArg);
	static tVoid bUnRegisterDrivers(tVoid *pvArg);
	static tBool bStartHandler(const tVoid *pvArg);
	static tVoid *pfSmsInitThreadFn(void *);

	tBool initializeSRM_Object();
	tBool initializeModule_Object();
	static tVoid cb_vSRMEventCallbackLocal(SRM_OBJECT hSRM, SRM_EVENT_MASK tEventMask, tVoid *pvEventCallbackArg);
	static tVoid cb_vModuleEventCallbackLocal(MODULE_OBJECT hModule, MODULE_EVENT_MASK tEventMask, tVoid *pvEventCallbackArg);

	tInt cond_timedwait(pthread_cond_t& condition, pthread_mutex_t& mutex, tInt timeInMs);

	tBool isFimwareAndModuleVersionSame();
	tBool isFirmwareNewer();
	tVoid logFirmwareAndModuleDetails(std::string l_firmwareFilePath);

public:

	virtual ~SiriusModuleHandler();

	tVoid setControllers(SXM_GPIO* gpio, SXM_VersionUtility* versionUtil);
	tBool powerOn();
	tBool powerOff();
	tBool reset();
	tVoid resetSXM();

	tBool initializeSMSThread();
	SXM_ERROR_CODE_ENUM initialize();
	tVoid deInitialize();

	SXM_ERROR_CODE_ENUM firmwareUpdate(std::string l_firmwareFilePath, tBool bForceUpdate, cbProgressInformation cbProgressUpdate);

	std::string getSerialVersionOfModule();
	std::string getHardwareVersionOfModule();
	std::string getHardwareTypeOfModule();
	std::string getSoftwareVersionOfModule();
	std::string getSoftwareVersionOfFirmware(std::string l_firmwareFilePath);
	std::string getHardwareTypeFromFirmware(std::string l_firmwareFilePath);


};




} // namespace SiriusModuleUpdateControlLib

#endif // _SXM_MODULE_HANDLER_H_
