/*******************************************************************************************
* FILE:			SWURecoveryHmiComponent.h
*
* SW-COMPONENT:Software Download
*
* DESCRIPTION:
*
*
* AUTHOR:		Aditya Kumar Jha
*
* COPYRIGHT:	(c) 2014 � 2015 Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
*********************************************************************************************
* HISTORY:
*					15.04.2014	Aditya Kumar Jha
*					Initial Version.
********************************************************************************************/
#include <iostream>
#include <algorithm>

#include "asf/core/ApplicationIF.h"
#include "asf/core/BaseComponent.h"
#include "asf/core/Logger.h"

#include "fcswupdatesrv/FcSwUpdateSrvProxy.h"

#include "../fbhmi/fbhmi_FbHmiManager.h"
#include <string>
#include <sstream>
#include <pthread.h>
#include <signal.h>

#include "RecoveryHmiDefine.h"

using namespace ::asf::core;
using namespace ::fcswupdatesrv::FcSwUpdateSrv;

namespace ai_sw_update {
namespace common {
namespace recovery_hmi {
namespace imp {

class SWURecoveryHmiComponent
: public BaseComponent
, private ServiceAvailableIF
#ifdef  VARIANT_S_FTR_ENABLE_SWU_DBUS
, private UpdateStateCallbackIF
, private UpdateProgressCallbackIF
, private UpdateBgImageInfoCallbackIF
#else
, private UpdateStateRegisterCallbackIF
, private UpdateProgressRegisterCallbackIF
, private UpdateBgImageInfoRegisterCallbackIF
#endif
//, FcSwUpdateSrvProxy
{
public:
  char *ProjectName;

	SWURecoveryHmiComponent();

	virtual ~SWURecoveryHmiComponent();

protected:

	// ServiceAvailableIF
	virtual void onAvailable(const ::boost::shared_ptr<Proxy>& proxy, const ServiceStateChange &stateChange);

	virtual void onUnavailable(const ::boost::shared_ptr<Proxy>& proxy, const ServiceStateChange &stateChange);
	virtual void onUpdateStateUpdate(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateStateUpdate >& update);
	virtual void onUpdateProgressUpdate(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateProgressUpdate >& update);

	virtual void onUpdateBgImageInfoUpdate(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateBgImageInfoUpdate >& update);

#ifdef  VARIANT_S_FTR_ENABLE_SWU_DBUS
	virtual void onUpdateStateError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateStateError >& error);
	virtual void onUpdateProgressError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateProgressError >& error);
	virtual void onUpdateBgImageInfoError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateBgImageInfoError >& Error);
#else
	virtual void onUpdateProgressRegisterError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateProgressRegisterError >& error);
	virtual void onUpdateStateRegisterError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateStateRegisterError >& error);
	virtual void onUpdateBgImageInfoRegisterError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateBgImageInfoRegisterError >& Error);
#endif



private:

	boost::shared_ptr< FcSwUpdateSrvProxy > m_recoveryHmiProxy;

	_tBool bInit;
	_tBool bProgBarInit;
	fbhmi_FbHmiManager* m_pclFbhmiMgr;
	_tU8 m_u8xResFactor;
	_tU8 m_u8yResFactor;
	_tU32 m_u32CompletedComponent;
	_tU32 m_u32FailedComponent;
	_tU32 m_u32AllComponent;
	_tU32 m_u32RunningComponent;
	_tU32 m_u32PercentReleaseComplete;
	stRecoveryHmiInterface stOldHMIInterface;
	stRecoveryHmiInterface stNewHMIInterface;
	_tBool bIsUpdateCompleted;
	fbhmiUpdateType enumUpdateType;

	pthread_t  m_stClockThread;

	static _tVoid* vClockThreadCallback(_tVoid* arg)
	{
		reinterpret_cast<SWURecoveryHmiComponent *>(arg)->vElapsedTimeThreadFunction();
		return NULL;
	}

	_tVoid vElapsedTimeThreadFunction();

	// SVG Console Initialized
	_tVoid vInitDisplay();

	// Display clear
	_tVoid vClearHMI();

	// Interface implementation for displaying the Download message on the display
	//_tVoid vShowMessage(_tCString);

	// Interface implementation for displaying the Elapse time on the display
	_tVoid vShowElapsetime(_tCString);

	// Interface implementation for displaying the Progress Bar on the display
	_tVoid vShowProgressBar(_tUInt);

	// Interface implementation for displaying the Download medium Source Info on the display
	_tVoid vShowSource(_tCString);

	// Interface implementation for displaying the Status of the update on the display
	_tVoid vShowStatus(_tCString);

	// Interface implementation for displaying the File name on the display
	_tVoid vShowFileName(_tCString);

	// Interface implementation for displaying the System info on the display
	_tVoid vShowSysType(_tCString);

	// Interface implementation for displaying the version info on the display
	_tVoid vShowSysVer(_tCString);

	// Interface implementation for displaying the LUA output on the display
	_tVoid vShowLUAOutput(_tCString, _tU32);

	// Interface implementation for displaying the LUA command on the display
	_tVoid vShowLUACmd(_tCString);

	// Update screen
	_tVoid vUpdateHMI();

	// display status
	_tVoid vDisplayStatus();

	//Create static screen
	_tVoid vShowStaticScreen();

	//Create OTAstatic screen
	_tVoid vShowOtaStaticScreen();

	// Interface implementation for displaying the colour to indicate the success/Failure
	_tVoid vUpdateOtaDownloadResult(_tBool);

	// Interface implementation for displaying the Progress Bar on the display for ota update
	_tVoid vShowOtaProgressBar(_tUInt);

	// Interface implementation for displaying the Progress value for ota update.
	_tVoid vShowOtaProgressValue(_tUInt);

	//set the update type (OTA or NON-OTA)
	_tVoid vSetUpdateType();

	DECLARE_CLASS_LOGGER ();
};

} // imp
} // recovery_hmi
} //common
}// ai_sw_update
