/*******************************************************************************************
* FILE:			SWURecoveryHmiComponent.cpp
*
* SW-COMPONENT:Software Download
*
* DESCRIPTION:
*
*
* AUTHOR:		Aditya Kumar Jha
*
* COPYRIGHT:	(c) 2014 � 2015 Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
*********************************************************************************************
* HISTORY:
*					15.04.2014	Aditya Kumar Jha
*					Initial Version.
*					19.05.2014	Aditya Kumar Jha
*					Implementation added for onUpdateProgressUpdate().
*					11.08.2014	Apoorva Kasugar Ravi
*					Fixed Lint Prio2 Warnings.
********************************************************************************************/

#include "SWURecoveryHmiComponent.h"

#include <unistd.h>
#include <time.h>

#define TEN 10


namespace ai_sw_update {
namespace common {
namespace recovery_hmi {
namespace imp {

DEFINE_CLASS_LOGGER_AND_LEVEL ("ai_sw_update/common/recovery_hmi/imp", SWURecoveryHmiComponent, Info);

static void copyString(char *dst, char const *src) {
   strncpy(dst, src, R_HMI_MAX_BUFFER_SIZE);
   dst[R_HMI_MAX_BUFFER_SIZE - 1]= 0;
}

SWURecoveryHmiComponent::SWURecoveryHmiComponent() :
	m_recoveryHmiProxy(FcSwUpdateSrvProxy::createProxy("fcSwUpdatePort",*this))
{
  const char  *tmpName=getenv("PROJECT_NAME");
  if(!tmpName)
    tmpName="None";
  ProjectName=strdup(tmpName);

  //Initilize the member variable
	bInit = FALSE;
	bProgBarInit = FALSE;
	m_pclFbhmiMgr = NULL;
	m_u8xResFactor = 1;
	m_u8yResFactor = 1;
	m_u32CompletedComponent = 0;
	m_u32FailedComponent = 0;
	m_u32AllComponent = 0;
	m_u32RunningComponent = 0;
	m_u32PercentReleaseComplete = 0;

	//Initilize the structure stOldHMIInterface
	stOldHMIInterface.enumHmiState = R_HMI_EN_STATE_NOT_READY;
	stOldHMIInterface.uintProgress = 0;
	stOldHMIInterface.ArrPlatformVer[0] = '\0';
	stOldHMIInterface.ArrSourceType[0] = '\0';
	stOldHMIInterface.ArrSysType[0] = '\0';
	stOldHMIInterface.ArrTargetSysVer[0] = '\0';
	stOldHMIInterface.ArrMediaSysVer[0] = '\0';
	stOldHMIInterface.ArrFileName[0] = '\0';
	stOldHMIInterface.ArrElapseTime[0] = '\0';
	stOldHMIInterface.ArrLUACmd[0] = '\0';
        int i;
        for (i=0;i<R_HMI_MAX_LUA_OUTPUT_LINES;++i) {
           stOldHMIInterface.ArrLUAOutput[i][0] = '\0';
        }

	//Initilize the structure stNewHMIInterface
	stNewHMIInterface.enumHmiState = R_HMI_EN_STATE_NOT_READY;
	stNewHMIInterface.uintProgress = 0;
	stNewHMIInterface.ArrPlatformVer[0] = '\0';
	stNewHMIInterface.ArrSourceType[0] = '\0';
	stNewHMIInterface.ArrSysType[0] = '\0';
	stNewHMIInterface.ArrTargetSysVer[0] = '\0';
	stNewHMIInterface.ArrMediaSysVer[0] = '\0';
	stNewHMIInterface.ArrFileName[0] = '\0';
	stNewHMIInterface.ArrElapseTime[0] = '\0';
	stNewHMIInterface.ArrLUACmd[0] = '\0';
        for (i=0;i<R_HMI_MAX_LUA_OUTPUT_LINES;++i) {
           stNewHMIInterface.ArrLUAOutput[i][0] = '\0';
        }

	bIsUpdateCompleted = FALSE;
	enumUpdateType = FBHMI_NON_OTA_UPDATE;
	vSetUpdateType();
	//vUpdateHMI();
}

SWURecoveryHmiComponent::~SWURecoveryHmiComponent()
{
  delete m_pclFbhmiMgr; // No need to check for NULL, delete does this anyways
  free(ProjectName);    // No need to check for NULL, free does this anyways
}

void SWURecoveryHmiComponent::onAvailable(const ::boost::shared_ptr<Proxy>& proxy, const ServiceStateChange &stateChange)
{
  if (m_recoveryHmiProxy == proxy)
  	{
		LOG_INFO("Recovery hmi Client available");
		//register for property updates
		m_recoveryHmiProxy->sendUpdateStateRegister(*this);
		m_recoveryHmiProxy->sendUpdateProgressRegister(*this);
		m_recoveryHmiProxy->sendUpdateBgImageInfoRegister(*this);
		//initiate screen
		vUpdateHMI();
		}
}

void SWURecoveryHmiComponent::onUnavailable(const ::boost::shared_ptr<Proxy>& proxy, const ServiceStateChange &stateChange)
{
	if (m_recoveryHmiProxy == proxy)
	{
		LOG_INFO("Recovery hmi Client unavailable");
		//deregister property KeyInfo
		m_recoveryHmiProxy->sendUpdateStateDeregisterAll();
		m_recoveryHmiProxy->sendUpdateSourcesDeregisterAll();
		m_recoveryHmiProxy->sendUpdateProgressDeregisterAll();
		m_recoveryHmiProxy->sendUpdateBgImageInfoDeregisterAll();

		pthread_kill(m_stClockThread, SIGTERM);
	}

}

void SWURecoveryHmiComponent::onUpdateStateUpdate(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateStateUpdate >& update)
{

           LOG_INFO("onUpdateStateUpdate START");
  	if ( proxy->hasUpdateState() )
  	{
#ifdef  VARIANT_S_FTR_ENABLE_SWU_DBUS
           LOG_INFO("onUpdateStateUpdate: new state = %u", update->getUpdateState().getEnState());           

  	   copyString(stNewHMIInterface.ArrTargetSysVer, (update->getUpdateState().getTrain()).c_str());
		//copyString(stNewHMIInterface.ArrTargetSysVer, (update->getData().getTrain()).c_str());

		stNewHMIInterface.enumHmiState = (R_HMI_FBHMI_STATE_TYPE) update->getUpdateState().getEnState();
#else
		copyString(stNewHMIInterface.ArrTargetSysVer, (update->getData().getTrain()).c_str());

		stNewHMIInterface.enumHmiState = (R_HMI_FBHMI_STATE_TYPE) update->getData().getEnState();
#endif
		//Update value on screen
		vUpdateHMI();

		}

}

#ifdef  VARIANT_S_FTR_ENABLE_SWU_DBUS
void SWURecoveryHmiComponent::onUpdateStateError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateStateError >& error)
#else
void SWURecoveryHmiComponent::onUpdateStateRegisterError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateStateRegisterError >& error)
#endif
{
	LOG_INFO("onUpdateStateError");
}

void SWURecoveryHmiComponent::onUpdateProgressUpdate(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateProgressUpdate >& update)
{
  LOG_INFO("onUpdateProgressUpdate");

#ifdef  VARIANT_S_FTR_ENABLE_SWU_DBUS
  const trUpdProgress &updateProgress = update->getUpdateProgress();

#else
  const trUpdProgress &updateProgress = update->getData();
#endif

  // number of subModules flashed successfully
  m_u32CompletedComponent = updateProgress.getU32NumComplete();

  // number of subModules where flashing failed
  m_u32FailedComponent = updateProgress.getU32NumFailed();

  // number of subModules that are currently beeing flashed
  m_u32RunningComponent = updateProgress.getU32NumRunning();

  //Total number of component to be flashed
  m_u32AllComponent = updateProgress.getU32NumAll();

  //Total number of component to be flashed
  m_u32PercentReleaseComplete = updateProgress.getU8ReleasePercentComplete();


  //LOG_INFO("u32CompletedComponent = %d, u32FailedComponent = %d, u32RemainingComponent = %d", m_u32CompletedComponent, m_u32FailedComponent, m_u32RemainingComponent);

  //calculate the progress
  if ( m_u32AllComponent != 0 )
    {
      stNewHMIInterface.uintProgress = m_u32PercentReleaseComplete;
    }

  //get the file name
  copyString(stNewHMIInterface.ArrFileName, (updateProgress.getRefKey()).c_str());

  //get the source type
  copyString(stNewHMIInterface.ArrSourceType, (updateProgress.getSource()).c_str());

  //get media software version
  copyString(stNewHMIInterface.ArrMediaSysVer, (updateProgress.getTrain()).c_str());


  //get LUA output line1
  strncpy(stNewHMIInterface.ArrLUAOutput[0],(proxy->getUpdateProgress().getLine1()).c_str(), R_HMI_MAX_BUFFER_SIZE);

  //get LUA output line2
  copyString(stNewHMIInterface.ArrLUAOutput[1],(updateProgress.getLine2()).c_str());

  //get LUA cmd
  copyString(stNewHMIInterface.ArrLUACmd,(updateProgress.getLuaCmd()).c_str());

  //Update value on screen
  vUpdateHMI();

}

#ifdef  VARIANT_S_FTR_ENABLE_SWU_DBUS
void SWURecoveryHmiComponent::onUpdateProgressError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateProgressError >& error)
#else
void SWURecoveryHmiComponent::onUpdateProgressRegisterError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateProgressRegisterError >& error)
#endif
{
	LOG_INFO("onUpdateProgressError");
}

void SWURecoveryHmiComponent::onUpdateBgImageInfoUpdate(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateBgImageInfoUpdate >& update)
{
#ifdef  VARIANT_S_FTR_ENABLE_SWU_DBUS
  const trBgImageInfo &updateImageInfo = update->getUpdateBgImageInfo();

#else
  const trBgImageInfo &updateImageInfo = update->getData();
#endif

	string strImagePath = updateImageInfo.getImgDirPath();
	string strImageName = updateImageInfo.getImgName();

	LOG_INFO("SWURecoveryHmiComponent::onUpdateBgImageInfoUpdate");

}

#ifndef  VARIANT_S_FTR_ENABLE_SWU_DBUS
// Wrong name was onUpdateBgInfoRegisterError
void SWURecoveryHmiComponent::onUpdateBgImageInfoRegisterError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateBgImageInfoRegisterError >& Error)
{
	LOG_INFO("onUpdateBackGndImageError");
}
#else
void SWURecoveryHmiComponent::onUpdateBgImageInfoError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateBgImageInfoError >& Error)
{
	LOG_INFO("onUpdateBackGndImageError");
}
#endif



/*************************************************************************
*
* FUNCTION: SWURecoveryHmiComponent::vInitDisplay()
*
* DESCRIPTION:
*
*  Constructor: - Initialize the Display driver
*
*
* PARAMETER: _tVoid
*
* RETURNVALUE: none
*
*************************************************************************/
_tVoid SWURecoveryHmiComponent::vInitDisplay()
{

	std::string strPlatformVer = "  PLATFORM VER. XXXXXXXX  ";
	//initialize fbhmi manager for the recovery HMI
	m_pclFbhmiMgr = new fbhmi_FbHmiManager(	R_HMI_FBHMI_SCREEN_WIDTH,
															R_HMI_FBHMI_SCREEN_HEIGHT,
															R_HMI_FBHMI_SCREEN_BWIDTH,
															strPlatformVer,
															R_HMI_FBHMI_SCREEN_TEXT_COLOR,
															FBHMI_COLOR_BLACK,
															FBHMI_COLOR_ORANGE,
															enumUpdateType);
	if( m_pclFbhmiMgr == NULL )
	{
		return;
	}

	if(!m_pclFbhmiMgr->bIsManagerInit())
	{
		LOG_INFO("DNL_FBHMI:fbhmi_FbHmiManager initialization failed..recovery HMI will not be started");
	}
	else
	{
		m_u8xResFactor = (_tU8)(m_pclFbhmiMgr->u32GetXRes() / R_HMI_FBHMI_SCREEN_WIDTH);
		m_u8yResFactor = (_tU8)(m_pclFbhmiMgr->u32GetYRes() / R_HMI_FBHMI_SCREEN_HEIGHT);
		bInit = TRUE;

		if(enumUpdateType == FBHMI_NON_OTA_UPDATE)
		{
		//create a thread
		pthread_create(&m_stClockThread, NULL, &SWURecoveryHmiComponent::vClockThreadCallback, this);
		}


	}


}

/************************************************************************
* FUNCTION: vElapsedTimeThreadFunction
*
* DESCRIPTION:The thread function responsible for displaying
*			  Elapsed download Time.
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
_tVoid SWURecoveryHmiComponent::vElapsedTimeThreadFunction()
{
	_tChar format[TEN];
	_tS32 mMinutes = 0;
	_tS32 mSeconds = 0;
	_tS32 seconds= 0;

	LOG_INFO("Elapsed Time started");

	//display the time
	while( !(bIsUpdateCompleted) )
	{
		mMinutes = seconds / 60;
		mSeconds = seconds % 60;

		memset( format, 0, TEN );

		//To display the time in 00:00 format
		if ( (mSeconds < TEN) || (mMinutes < TEN) )
		{
			if ( (mSeconds < TEN) && (mMinutes < TEN) )
			{
				sprintf(format, "0%d:0%d", mMinutes, mSeconds);
			}
			else if ( mMinutes < TEN )
			{
				sprintf(format, "0%d:%d", mMinutes, mSeconds);
			}
			else
			{
				sprintf(format, "%d:0%d", mMinutes, mSeconds);
			}
		}
		else
		{
			sprintf(format, "%d:%d", mMinutes, mSeconds);
		}

		//create and display
		vShowElapsetime(format);

		sleep(TEN);
		seconds += TEN;

	}

}

/*************************************************************************
*
* FUNCTION: vClearHMI()
*
* DESCRIPTION: Clear HMI
*
*
* PARAMETER: none
*
* RETURNVALUE: none
*
*************************************************************************/
_tVoid SWURecoveryHmiComponent::vClearHMI()
{
	if( m_pclFbhmiMgr != NULL )
	{
		m_pclFbhmiMgr->bClearScreen(R_HMI_PRIMARY_SCREEN);
	}

}

/*************************************************************************
*
* FUNCTION: vShowElapsetime(_tCString StrElapseTime)
*
* DESCRIPTION: Displays the elapse time on the screen
*
*
* PARAMETER: StrElapseTime
*
* RETURNVALUE: none
*
*************************************************************************/
_tVoid SWURecoveryHmiComponent::vShowElapsetime(_tCString StrElapseTime)
{
	static _tBool bElapsedTimeInit=FALSE;

	std::string strElapsedTime = StrElapseTime;

	if( m_pclFbhmiMgr == NULL )
	{
		return;
	}

	if(FALSE == bElapsedTimeInit)
	{
		//create elapsed time label
		if(!m_pclFbhmiMgr->bCreateLabel(	R_HMI_PRIMARY_SCREEN,
													R_HMI_EN_ELAPSED_TIME_ID,
													(m_pclFbhmiMgr->u32GetXRes()) - (R_HMI_FBHMI_ELAPSE_TIME_X_OFFSET + R_HMI_FBHMI_ELAPSE_TIME_WIDTH * m_u8xResFactor),
													(m_pclFbhmiMgr->u32GetYRes()) - (R_HMI_FBHMI_ELAPSE_TIME_Y_OFFSET + R_HMI_FBHMI_ELAPSE_TIME_HEIGHT * m_u8yResFactor),
													R_HMI_FBHMI_ELAPSE_TIME_WIDTH * m_u8xResFactor,
													R_HMI_FBHMI_ELAPSE_TIME_HEIGHT * m_u8yResFactor,
													R_HMI_FBHMI_ELAPSE_TIME_BWIDTH,
													R_HMI_FBHMI_SCREEN_TEXT_COLOR,
													R_HMI_FBHMI_SCREEN_BG_COLOR,
													R_HMI_FBHMI_SCREEN_BORDER_COLOR,
													strElapsedTime,
													R_HMI_FBHMI_ELAPSE_TIME_ALIGN,
													R_HMI_FBHMI_VAR_TEXT_VISIBILITY))
		{
			bInit = FALSE;
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vInitDisplay create elapsed time label failed");
		}
		bElapsedTimeInit=TRUE;
	}
	else
	{
		if(!m_pclFbhmiMgr->bUpdateText(R_HMI_PRIMARY_SCREEN, R_HMI_EN_ELAPSED_TIME_ID,
			strElapsedTime, R_HMI_FBHMI_VAR_TEXT_ALIGN,
			R_HMI_FBHMI_VAR_TEXT_VISIBILITY))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowElapsetime elapsed time update failed");
		}
	}
}

/*************************************************************************
*
* FUNCTION: vShowProgressBar(_tUInt uintValue)
*
* DESCRIPTION: Displays the Progress bar on the screen
*
*
* PARAMETER: uintValue
*
* RETURNVALUE: none
*
*************************************************************************/
_tVoid SWURecoveryHmiComponent::vShowProgressBar(_tUInt uintValue)
{
	if(((uintValue ==  R_HMI_U32_BAR_MIN_VALUE) || (uintValue >  R_HMI_U32_BAR_MIN_VALUE))  &&
		(uintValue <=  R_HMI_U32_BAR_MAX_VALUE))
	{
		LOG_INFO("DNL: dl_HMISysProgController::Progress value is correct ");
	}
	else
	{
		uintValue = 0;
		LOG_INFO("DNL: dl_HMISysProgController::Progress value is cut short to 0 ");
	}

	std::string strPbarText = "copying ";
	std::stringstream  sstrPbarText;
	sstrPbarText << uintValue << "/100";
	strPbarText.append(sstrPbarText.str());

	if( m_pclFbhmiMgr != NULL )
	{
		//update prog bar value
		if(!m_pclFbhmiMgr->bUpdateProgress(R_HMI_PRIMARY_SCREEN, R_HMI_EN_DNL_PBAR_ID, uintValue, R_HMI_FBHMI_PROGRESS_BAR_MAX_VALUE))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowProgressBar failed to update DNL progress bar value");
		}
		//update prog bar text
		if(!m_pclFbhmiMgr->bUpdateText(R_HMI_PRIMARY_SCREEN, R_HMI_EN_DNL_PBAR_ID, strPbarText, FBHMI_TXT_ALIGN_CENTER, true))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowProgressBar failed to update DNL progress bar text");
		}
	}
}
/*************************************************************************
*
* FUNCTION: vShowSource(_tCString StrSrc)
*
* DESCRIPTION: Displays the Source Information on the screen
*
*
* PARAMETER: StrSrc
*
* RETURNVALUE: none
*
*************************************************************************/
_tVoid SWURecoveryHmiComponent::vShowSource(_tCString StrSrc)
{
	static _tBool bSourceInit= FALSE;
	std::string strSrc = StrSrc;

	if( m_pclFbhmiMgr == NULL )
	{
		return;
	}

	if(bSourceInit == FALSE)
	{
		//create source label variable text
		if(!m_pclFbhmiMgr->bCreateLabel(	R_HMI_PRIMARY_SCREEN,
													R_HMI_EN_SOURCE_VAR_TEXT_ID,
													R_HMI_FBHMI_SRC_VAR_TEXT_X * m_u8xResFactor,
													R_HMI_FBHMI_SRC_VAR_TEXT_Y * m_u8yResFactor,
													R_HMI_FBHMI_SRC_VAR_TEXT_WIDTH * m_u8xResFactor,
													R_HMI_FBHMI_SRC_VAR_TEXT_HEIGHT * m_u8yResFactor,
													R_HMI_FBHMI_SRC_VAR_TEXT_BWIDTH,
													R_HMI_FBHMI_VAR_TEXT_FG_COLOR,
													R_HMI_FBHMI_VAR_TEXT_BG_COLOR,
													R_HMI_FBHMI_VAR_TEXT_BORDER_COLOR,
													strSrc,
													R_HMI_FBHMI_VAR_TEXT_ALIGN,
													R_HMI_FBHMI_VAR_TEXT_VISIBILITY))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowSource create source label for variable text failed");
		}
		else
		{
			bSourceInit = TRUE;
		}
	}
	else
	{
		//update source texts
		if(!m_pclFbhmiMgr->bUpdateText(R_HMI_PRIMARY_SCREEN, R_HMI_EN_SOURCE_VAR_TEXT_ID, strSrc, FBHMI_TXT_ALIGN_LEFT, true))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowSource failed to update source text");
		}
	}
}

/*************************************************************************
*
* FUNCTION: vShowStatus(_tCString StrStatus)
*
* DESCRIPTION: Displays the Status Information on the screen
*
*
* PARAMETER: StrStatus
*
* RETURNVALUE: none
*
*************************************************************************/
_tVoid SWURecoveryHmiComponent::vShowStatus(_tCString StrStatus)
{

	if ( (m_pclFbhmiMgr == NULL) || (StrStatus  == NULL) )
	{
		return;
	}

	static _tBool bStatusInit= FALSE;
	std::string strStatus = StrStatus;

	if(FALSE == bStatusInit)
	{
		//create source label variable text
		if(!m_pclFbhmiMgr->bCreateLabel(	R_HMI_PRIMARY_SCREEN,
													R_HMI_EN_STATUS_VAR_TEXT_ID,
													R_HMI_FBHMI_STAT_VAR_TEXT_X * m_u8xResFactor,
													R_HMI_FBHMI_STAT_VAR_TEXT_Y * m_u8yResFactor,
													R_HMI_FBHMI_STAT_VAR_TEXT_WIDTH * m_u8xResFactor,
													R_HMI_FBHMI_STAT_VAR_TEXT_HEIGHT * m_u8yResFactor,
													R_HMI_FBHMI_STAT_VAR_TEXT_BWIDTH,
													R_HMI_FBHMI_VAR_TEXT_FG_COLOR,
													R_HMI_FBHMI_VAR_TEXT_BG_COLOR,
													R_HMI_FBHMI_VAR_TEXT_BORDER_COLOR,
													strStatus,
													R_HMI_FBHMI_VAR_TEXT_ALIGN,
													R_HMI_FBHMI_VAR_TEXT_VISIBILITY))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowStatus create status label for variable text failed");
		}
		else
		{
			bStatusInit = TRUE;
		}
	}
	else
	{
		//update status texts
		if(!m_pclFbhmiMgr->bUpdateText(R_HMI_PRIMARY_SCREEN, R_HMI_EN_STATUS_VAR_TEXT_ID, strStatus, FBHMI_TXT_ALIGN_LEFT, true))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowStatus failed to update status text");
		}
	}
}

/*************************************************************************
*
* FUNCTION: vShowFileName(_tCString StrFileName)
*
* DESCRIPTION: Displays the File Name on the screen
*
*
* PARAMETER: StrFileName
*
* RETURNVALUE: none
*
*************************************************************************/
_tVoid SWURecoveryHmiComponent::vShowFileName(_tCString StrFileName)
{
	static _tBool bFileNameInit= FALSE;
	std::string strFileName = StrFileName;

	if( m_pclFbhmiMgr == NULL )
	{
		return;
	}

	if(FALSE == bFileNameInit)
	{
		//create filename label for variable text
		if(!m_pclFbhmiMgr->bCreateLabel(	R_HMI_PRIMARY_SCREEN,
													R_HMI_EN_FILE_NAME_VAR_TEXT_ID,
													R_HMI_FBHMI_FILE_VAR_TEXT_X * m_u8xResFactor,
													R_HMI_FBHMI_FILE_VAR_TEXT_Y * m_u8yResFactor,
													R_HMI_FBHMI_FILE_VAR_TEXT_WIDTH * m_u8xResFactor,
													R_HMI_FBHMI_FILE_VAR_TEXT_HEIGHT * m_u8yResFactor,
													R_HMI_FBHMI_FILE_VAR_TEXT_BWIDTH,
													R_HMI_FBHMI_VAR_TEXT_FG_COLOR,
													R_HMI_FBHMI_VAR_TEXT_BG_COLOR,
													R_HMI_FBHMI_VAR_TEXT_BORDER_COLOR,
													strFileName,
													R_HMI_FBHMI_VAR_TEXT_ALIGN,
													R_HMI_FBHMI_VAR_TEXT_VISIBILITY))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowFileName create filename label for variable text failed");
		}
		else
		{
			bFileNameInit = TRUE;
		}
	}
	else
	{
		//update filename text
		if(!m_pclFbhmiMgr->bUpdateText(R_HMI_PRIMARY_SCREEN, R_HMI_EN_FILE_NAME_VAR_TEXT_ID, strFileName, FBHMI_TXT_ALIGN_LEFT, true))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowFileName failed to update file name");
		}
	}
}

/*************************************************************************
*
* FUNCTION: vShowSysType(_tCString StrSysType)
*
* DESCRIPTION: Displays the System Type Information on the screen
*
* PARAMETER: StrSysType
*
* RETURNVALUE: none
*
*************************************************************************/
_tVoid SWURecoveryHmiComponent::vShowSysType(_tCString StrSysType)
{
	static _tBool bSysType= FALSE;
	std::string strSysType = StrSysType;

	if( m_pclFbhmiMgr == NULL )
	{
		return;
	}

	if(FALSE == bSysType)
	{
		//create system type label for variable text
		if(!m_pclFbhmiMgr->bCreateLabel(	R_HMI_PRIMARY_SCREEN,
													R_HMI_EN_SYSTEM_TYPE_VAR_TEXT_ID,
													R_HMI_FBHMI_SYS_VAR_TEXT_X * m_u8xResFactor,
													R_HMI_FBHMI_SYS_VAR_TEXT_Y * m_u8yResFactor,
													R_HMI_FBHMI_SYS_VAR_TEXT_WIDTH * m_u8xResFactor,
													R_HMI_FBHMI_SYS_VAR_TEXT_HEIGHT * m_u8yResFactor,
													R_HMI_FBHMI_SYS_VAR_TEXT_BWIDTH,
													R_HMI_FBHMI_VAR_TEXT_FG_COLOR,
													R_HMI_FBHMI_VAR_TEXT_BG_COLOR,
													R_HMI_FBHMI_VAR_TEXT_BORDER_COLOR,
													strSysType,
													R_HMI_FBHMI_VAR_TEXT_ALIGN,
													R_HMI_FBHMI_VAR_TEXT_VISIBILITY))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowSysType create system type label for variable text failed");
		}
		else
		{
			bSysType = TRUE;
		}
	}
	else
	{
		//update filename text
		if(!m_pclFbhmiMgr->bUpdateText(R_HMI_PRIMARY_SCREEN, R_HMI_EN_SYSTEM_TYPE_VAR_TEXT_ID, strSysType, FBHMI_TXT_ALIGN_LEFT, true))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowSysType failed to update system type");
		}
	}


}

/*************************************************************************
*
* FUNCTION: vShowSysVer(_tCString StrSysVer)
*
* DESCRIPTION: Displays the System version Information on the screen
*
* PARAMETER: StrSysVer
*
* RETURNVALUE: none
*
*************************************************************************/
_tVoid SWURecoveryHmiComponent::vShowSysVer(_tCString StrSysVer)
{

	static _tBool bSysVer= FALSE;
	std::string strSysVer = StrSysVer;

	if( m_pclFbhmiMgr == NULL )
	{
		return;
	}

	if(FALSE == bSysVer)
	{
		//create system type label
		if(!m_pclFbhmiMgr->bCreateLabel(	R_HMI_PRIMARY_SCREEN,
													R_HMI_EN_SYSTEM_VERSION_TEXT_ID,
													R_HMI_FBHMI_SYSVER_VAR_TEXT_X * m_u8xResFactor,
													R_HMI_FBHMI_SYSVER_VAR_TEXT_Y * m_u8yResFactor,
													R_HMI_FBHMI_SYSVER_VAR_TEXT_WIDTH * m_u8xResFactor,
													R_HMI_FBHMI_SYSVER_VAR_TEXT_HEIGHT * m_u8yResFactor,
													R_HMI_FBHMI_SYSVER_VAR_TEXT_BWIDTH,
													R_HMI_FBHMI_FIX_TEXT_FG_COLOR,
													R_HMI_FBHMI_FIX_TEXT_BG_COLOR,
													R_HMI_FBHMI_FIX_TEXT_BORDER_COLOR,
													strSysVer,
													FBHMI_TXT_ALIGN_CENTER,
													R_HMI_FBHMI_VAR_TEXT_VISIBILITY))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowSysVer create system version label failed");
		}
		else
		{
			bSysVer = TRUE;
		}
	}
	else
	{
		//update system version text
		if(!m_pclFbhmiMgr->bUpdateText(R_HMI_PRIMARY_SCREEN, R_HMI_EN_SYSTEM_VERSION_TEXT_ID, strSysVer, FBHMI_TXT_ALIGN_CENTER, true))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowSysVer failed to update system version");
		}
	}
}

/*************************************************************************
*
* FUNCTION: vShowLUAOutput(_tCString StrLUAOutput)
*
* DESCRIPTION: Displays the LUA script ouput Information on the screen
*
* PARAMETER: StrLUAOutput
*
* RETURNVALUE: none
*
*************************************************************************/
_tVoid SWURecoveryHmiComponent::vShowLUAOutput(_tCString StrLUAOutput,_tU32 u32LUAOuputLine)
{
	static _tBool bLuaOutputLine1 = FALSE;
	static _tBool bLuaOutputLine2 = FALSE;
	std::string strLUAOutput = StrLUAOutput;
	if( m_pclFbhmiMgr == NULL )
	{
		return;
	}

	if(FALSE == bLuaOutputLine1)
	{
		//create LUA output line 1 label
		if(!m_pclFbhmiMgr->bCreateLabel(	R_HMI_PRIMARY_SCREEN,
													R_HMI_EN_LUA_OUTPUT_LINE_1_TEXT_ID,
													R_HMI_FBHMI_LUAOUT_1_X * m_u8xResFactor,
													R_HMI_FBHMI_LUAOUT_1_Y * m_u8yResFactor,
													R_HMI_FBHMI_LUAOUT_1_WIDTH * m_u8xResFactor,
													R_HMI_FBHMI_LUAOUT_1_HEIGHT * m_u8yResFactor,
													R_HMI_FBHMI_LUAOUT_1_BWIDTH,
													R_HMI_FBHMI_VAR_TEXT_FG_COLOR,
													R_HMI_FBHMI_VAR_TEXT_BG_COLOR,
													R_HMI_FBHMI_VAR_TEXT_BORDER_COLOR,
													strLUAOutput,
													R_HMI_FBHMI_VAR_TEXT_ALIGN,
													R_HMI_FBHMI_VAR_TEXT_VISIBILITY))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowSysVer create system version label failed");
		}
		else
		{
			bLuaOutputLine1 = TRUE;
		}
	}
	else
	{
		if(R_HMI_LUA_OUTPUT_LINE_1 == u32LUAOuputLine)
		{
			//update lua output line 1
			if(!m_pclFbhmiMgr->bUpdateText(R_HMI_PRIMARY_SCREEN, R_HMI_EN_LUA_OUTPUT_LINE_1_TEXT_ID, strLUAOutput, FBHMI_TXT_ALIGN_LEFT, true))
			{
				LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowSysVer failed to update system version");
			}
		}
	}

	if(FALSE == bLuaOutputLine2)
	{
		//create LUA output line 2 label
		if(!m_pclFbhmiMgr->bCreateLabel( R_HMI_PRIMARY_SCREEN,
													R_HMI_EN_LUA_OUTPUT_LINE_2_TEXT_ID,
													R_HMI_FBHMI_LUAOUT_2_X * m_u8xResFactor,
													R_HMI_FBHMI_LUAOUT_2_Y * m_u8yResFactor,
													R_HMI_FBHMI_LUAOUT_2_WIDTH * m_u8xResFactor,
													R_HMI_FBHMI_LUAOUT_2_HEIGHT * m_u8yResFactor,
													R_HMI_FBHMI_LUAOUT_2_BWIDTH,
													R_HMI_FBHMI_VAR_TEXT_FG_COLOR,
													R_HMI_FBHMI_VAR_TEXT_BG_COLOR,
													R_HMI_FBHMI_VAR_TEXT_BORDER_COLOR,
													strLUAOutput,
													R_HMI_FBHMI_VAR_TEXT_ALIGN,
													R_HMI_FBHMI_VAR_TEXT_VISIBILITY))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowSysVer create system version label failed");
		}
		else
		{
			bLuaOutputLine2 = TRUE;
		}
	}
	else
	{
		if(R_HMI_LUA_OUTPUT_LINE_2 == u32LUAOuputLine)
		{
			//update LUA output line 2
			if(!m_pclFbhmiMgr->bUpdateText(R_HMI_PRIMARY_SCREEN, R_HMI_EN_LUA_OUTPUT_LINE_2_TEXT_ID, strLUAOutput, FBHMI_TXT_ALIGN_LEFT, true))
			{
				LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowSysVer failed to update system version");
			}
		}
	}

}

/*************************************************************************
*
* FUNCTION: vShowLUACmd(_tCString StrLUACmd)
*
* DESCRIPTION: Displays the System Type Information on the screen
*
* PARAMETER: StrLUACmd
*
* RETURNVALUE: none
*
*************************************************************************/
_tVoid SWURecoveryHmiComponent::vShowLUACmd(_tCString StrLUACmd)
{
	static _tBool bLuaCmd = FALSE;
	std::string strLUACmd = StrLUACmd;

	if( m_pclFbhmiMgr == NULL )
	{
		return;
	}

	if(FALSE == bLuaCmd)
	{
		if(!m_pclFbhmiMgr->bCreateLabel( R_HMI_PRIMARY_SCREEN,
													R_HMI_EN_LUA_COMMAND_VAR_TEXT_ID,
													R_HMI_FBHMI_LUA_VAR_CMD_X * m_u8xResFactor,
													R_HMI_FBHMI_LUA_VAR_CMD_Y * m_u8yResFactor,
													R_HMI_FBHMI_LUA_VAR_CMD_WIDTH * m_u8xResFactor,
													R_HMI_FBHMI_LUA_VAR_CMD_HEIGHT * m_u8yResFactor,
													R_HMI_FBHMI_LUA_VAR_CMD_BWIDTH,
													R_HMI_FBHMI_VAR_TEXT_FG_COLOR,
													R_HMI_FBHMI_VAR_TEXT_BG_COLOR,
													R_HMI_FBHMI_VAR_TEXT_BORDER_COLOR,
													strLUACmd,
													R_HMI_FBHMI_VAR_TEXT_ALIGN,
													R_HMI_FBHMI_VAR_TEXT_VISIBILITY))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowLUACmd create lua command variable text label failed");
		}
		else
		{
			bLuaCmd = TRUE;
		}

	}
	else
	{
		//update lua cmd
		if(!m_pclFbhmiMgr->bUpdateText(R_HMI_PRIMARY_SCREEN, R_HMI_EN_LUA_COMMAND_VAR_TEXT_ID, strLUACmd, FBHMI_TXT_ALIGN_LEFT, true))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowLUACmd failed to update LUA command");
		}
	}
}

/*************************************************************************
*
* FUNCTION: vUpdateHMI()
*
* DESCRIPTION: Interface function with the download core
*
*
* PARAMETER: NONE
*
* RETURNVALUE: none
*
*************************************************************************/
_tVoid SWURecoveryHmiComponent::vUpdateHMI()
{



   switch(enumUpdateType)
   {
   case FBHMI_NON_OTA_UPDATE:

	if(FALSE == bInit)
	{
		vInitDisplay();
		vShowStaticScreen();
	}
	else
	{

		// SRC display
           if( strcmp(stNewHMIInterface.ArrSourceType, stOldHMIInterface.ArrSourceType)
			&&
			(stNewHMIInterface.enumHmiState == R_HMI_EN_STATE_RUNNING ) )
		{
			copyString(stOldHMIInterface.ArrSourceType, stNewHMIInterface.ArrSourceType);
			// Display the message
			vShowSource(stNewHMIInterface.ArrSourceType);
		}

		// PROGRESS BAR display
		if(stNewHMIInterface.uintProgress != stOldHMIInterface.uintProgress)
		{
			stOldHMIInterface.uintProgress = stNewHMIInterface.uintProgress ;
			// Display the message
			vShowProgressBar(stNewHMIInterface.uintProgress);
		}

		// VERSION INFO display
		if(strcmp(stNewHMIInterface.ArrMediaSysVer, stOldHMIInterface.ArrMediaSysVer)
			&&
			(stNewHMIInterface.enumHmiState == R_HMI_EN_STATE_RUNNING ) )
		{
			copyString(stOldHMIInterface.ArrMediaSysVer, stNewHMIInterface.ArrMediaSysVer);
			_tChar ArrSysVer[R_HMI_MAX_BUFFER_SIZE] = {0};
			sprintf(ArrSysVer, "%s -> %s", stNewHMIInterface.ArrTargetSysVer, stNewHMIInterface.ArrMediaSysVer);

			// Display version Info
			vShowSysVer(ArrSysVer);
		}

		// System Type(FCID) display
		if(strcmp(stNewHMIInterface.ArrTargetSysVer,stOldHMIInterface.ArrTargetSysVer))
		{
			copyString(stOldHMIInterface.ArrTargetSysVer, stNewHMIInterface.ArrTargetSysVer);
			// Display System Type(FCID)
			vShowSysType(stNewHMIInterface.ArrTargetSysVer);
		}

		// LUA output display line1
		if (strcmp(stNewHMIInterface.ArrLUAOutput[0], stOldHMIInterface.ArrLUAOutput[0]))
		{
			copyString(stOldHMIInterface.ArrLUAOutput[0],stNewHMIInterface.ArrLUAOutput[0]);
			// Display LUA output
			vShowLUAOutput(stNewHMIInterface.ArrLUAOutput[0],R_HMI_LUA_OUTPUT_LINE_1);
		}

		// LUA output display line2
		if(strcmp(stNewHMIInterface.ArrLUAOutput[1], stOldHMIInterface.ArrLUAOutput[1]))
		{
			copyString(stOldHMIInterface.ArrLUAOutput[1],stNewHMIInterface.ArrLUAOutput[1]);
			// Display LUA output
			vShowLUAOutput(stNewHMIInterface.ArrLUAOutput[1],R_HMI_LUA_OUTPUT_LINE_2);
		}

		// LUA cmd
		if(strcmp(stNewHMIInterface.ArrLUACmd, stOldHMIInterface.ArrLUACmd))
		{
			copyString(stOldHMIInterface.ArrLUACmd,stNewHMIInterface.ArrLUACmd);
			// Display LUA output
			vShowLUACmd(stNewHMIInterface.ArrLUACmd);
		}



		/*	// LUA output display

		// LUA Command display
		if( (stHMIIntf.ArrLUACmd      != NULL)  &&
			(stHMIInterface.ArrLUACmd != NULL)  &&
			(stHMIIntf.ArrLUACmd      != stHMIInterface.ArrLUACmd) )
		{
			// Display LUA Cmd
			vShowLUACmd(stHMIInterface.ArrLUACmd);
		} */

		// File name display
		if( strcmp(stNewHMIInterface.ArrFileName, stOldHMIInterface.ArrFileName))
		{
			copyString(stOldHMIInterface.ArrFileName, stNewHMIInterface.ArrFileName);
			// Display File Info
			vShowFileName(stNewHMIInterface.ArrFileName);
		}


		// STATUS display
		if( (stNewHMIInterface.enumHmiState != stOldHMIInterface.enumHmiState)
			||
			(stNewHMIInterface.enumHmiState == R_HMI_EN_STATE_RUNNING )
			||
			(stNewHMIInterface.enumHmiState == R_HMI_EN_STATE_IDLE) )
		{
			stOldHMIInterface.enumHmiState = stNewHMIInterface.enumHmiState ;
			vDisplayStatus();
		}
	}
	break;
	case FBHMI_OTA_UPDATE:
	    if(FALSE == bInit)
	   {
		vInitDisplay();
		vShowOtaStaticScreen();
	   }
	   else
	  {
	       // PROGRESS BAR display
		if(stNewHMIInterface.uintProgress != stOldHMIInterface.uintProgress)
		{
			stOldHMIInterface.uintProgress = stNewHMIInterface.uintProgress ;
			// Display the message
			vShowOtaProgressBar(stNewHMIInterface.uintProgress);
			vShowOtaProgressValue(stNewHMIInterface.uintProgress);
		}

		// STATUS display
			if( stNewHMIInterface.enumHmiState == R_HMI_EN_STATE_RESULT )
			{
			  if ( m_u32FailedComponent == 0 )
		      {
			      vUpdateOtaDownloadResult(true);
		      }
		      else
		     {
		     	 vUpdateOtaDownloadResult(false);
		     }
			}

	   }
       break;
	 default:
	        LOG_INFO("enumUpdateType is not set correctly");
	       break;
	}
}

/*************************************************************************
*
* FUNCTION: vDisplayStatus()
*
* DESCRIPTION: Displays the Status Information on the screen
*
*
* PARAMETER: none
*
* RETURNVALUE: none
*
*************************************************************************/
_tVoid SWURecoveryHmiComponent::vDisplayStatus()
{
	_tChar StrStatusType[R_HMI_MAX_BUFFER_SIZE] = {0};

	if( stNewHMIInterface.enumHmiState == R_HMI_EN_STATE_RUNNING )
	{
		sprintf(StrStatusType, "Running (Module [%d] of [%d])", (m_u32FailedComponent + m_u32CompletedComponent + m_u32RunningComponent), (m_u32AllComponent));

		// Display the message
		vShowStatus(StrStatusType);

	}
	else if( stNewHMIInterface.enumHmiState == R_HMI_EN_STATE_NOT_READY )
	{
		sprintf(StrStatusType, "Initializing");

		// Display the message
		vShowStatus(StrStatusType);

	}
	else if( stNewHMIInterface.enumHmiState == R_HMI_EN_STATE_IDLE )
	{
		sprintf(StrStatusType, "Waiting for Update Media");

		// Display the message
		vShowStatus(StrStatusType);

	}
	else if( stNewHMIInterface.enumHmiState == R_HMI_EN_STATE_CONFIG )
	{
		sprintf(StrStatusType, "Insert-Update media");

		// Display the message
		vShowStatus(StrStatusType);
	}
	else if( stNewHMIInterface.enumHmiState == R_HMI_EN_STATE_RESULT )
	{
		if ( m_u32FailedComponent == 0 )
		{
			sprintf(StrStatusType, "Download Success, remove Update Media to reboot");
		}
		else
		{
			sprintf(StrStatusType, "Download Failed: %d/%d component failed", m_u32FailedComponent, (m_u32FailedComponent + m_u32CompletedComponent));
		}

		// Display the message
		vShowStatus(StrStatusType);

		bIsUpdateCompleted = TRUE;

	}

}

/*************************************************************************
*
* FUNCTION: vShowStaticScreen()
*
* DESCRIPTION: Displays the static screen
*
*
* PARAMETER: none
*
* RETURNVALUE: none
*
*************************************************************************/
_tVoid SWURecoveryHmiComponent::vShowStaticScreen()
{
	_tUInt uintValue = 0;
	std::string strPbarText = "copying ";
	std::stringstream  sstrPbarText;
	sstrPbarText << uintValue << "/100";
	strPbarText.append(sstrPbarText.str());

	//create source label for the fixed text
	if(NULL != m_pclFbhmiMgr)
	{
		if(!m_pclFbhmiMgr->bCreateLabel(	R_HMI_PRIMARY_SCREEN,
													R_HMI_EN_SOURCE_FIXED_TEXT_ID,
													R_HMI_FBHMI_SRC_FIX_TEXT_X * m_u8xResFactor,
													R_HMI_FBHMI_SRC_FIX_TEXT_Y * m_u8yResFactor,
													R_HMI_FBHMI_SRC_FIX_TEXT_WIDTH * m_u8xResFactor,
													R_HMI_FBHMI_SRC_FIX_TEXT_HEIGHT * m_u8yResFactor,
													R_HMI_FBHMI_SRC_FIX_TEXT_BWIDTH,
													R_HMI_FBHMI_FIX_TEXT_FG_COLOR,
													R_HMI_FBHMI_FIX_TEXT_BG_COLOR,
													R_HMI_FBHMI_FIX_TEXT_BORDER_COLOR,
													"Source:",
													R_HMI_FBHMI_FIX_TEXT_ALIGN,
													R_HMI_FBHMI_FIX_TEXT_VISIBILITY))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowSource create source label for fixed text failed");
		}

		//create status label for the fixed text
		if(!m_pclFbhmiMgr->bCreateLabel(	R_HMI_PRIMARY_SCREEN,
													R_HMI_EN_STATUS_FIXED_TEXT_ID,
													R_HMI_FBHMI_STAT_FIX_TEXT_X  * m_u8xResFactor,
													R_HMI_FBHMI_STAT_FIX_TEXT_Y  * m_u8yResFactor,
													R_HMI_FBHMI_STAT_FIX_TEXT_WIDTH * m_u8xResFactor,
													R_HMI_FBHMI_STAT_FIX_TEXT_HEIGHT * m_u8yResFactor,
													R_HMI_FBHMI_STAT_FIX_TEXT_BWIDTH,
													R_HMI_FBHMI_FIX_TEXT_FG_COLOR,
													R_HMI_FBHMI_FIX_TEXT_BG_COLOR,
													R_HMI_FBHMI_FIX_TEXT_BORDER_COLOR,
													"STATUS:",
													R_HMI_FBHMI_FIX_TEXT_ALIGN,
													R_HMI_FBHMI_FIX_TEXT_VISIBILITY))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowStatus create status label for fixed text failed");
		}

		//create filename label for the fixed text
		if(!m_pclFbhmiMgr->bCreateLabel(	R_HMI_PRIMARY_SCREEN,
													R_HMI_EN_FILE_NAME_FIXED_TEXT_ID,
													R_HMI_FBHMI_FILE_FIX_TEXT_X * m_u8xResFactor,
													R_HMI_FBHMI_FILE_FIX_TEXT_Y * m_u8yResFactor,
													R_HMI_FBHMI_FILE_FIX_TEXT_WIDTH * m_u8xResFactor,
													R_HMI_FBHMI_FILE_FIX_TEXT_HEIGHT * m_u8yResFactor,
													R_HMI_FBHMI_FILE_FIX_TEXT_BWIDTH,
													R_HMI_FBHMI_FIX_TEXT_FG_COLOR,
													R_HMI_FBHMI_FIX_TEXT_BG_COLOR,
													R_HMI_FBHMI_FIX_TEXT_BORDER_COLOR,
													"FILE:",
													R_HMI_FBHMI_FIX_TEXT_ALIGN,
													R_HMI_FBHMI_FIX_TEXT_VISIBILITY))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowFileName create filename label for fixed text failed");
		}

		//create system type label for the fixed text
		if(!m_pclFbhmiMgr->bCreateLabel(	R_HMI_PRIMARY_SCREEN,
													R_HMI_EN_SYSTEM_TYPE_FIXED_TEXT_ID,
													R_HMI_FBHMI_SYS_FIX_TEXT_X * m_u8xResFactor,
													R_HMI_FBHMI_SYS_FIX_TEXT_Y * m_u8yResFactor,
													R_HMI_FBHMI_SYS_FIX_TEXT_WIDTH * m_u8xResFactor,
													R_HMI_FBHMI_SYS_FIX_TEXT_HEIGHT * m_u8yResFactor,
													R_HMI_FBHMI_SYS_FIX_TEXT_BWIDTH,
													R_HMI_FBHMI_FIX_TEXT_FG_COLOR,
													R_HMI_FBHMI_FIX_TEXT_BG_COLOR,
													R_HMI_FBHMI_FIX_TEXT_BORDER_COLOR,
													"System:",
													R_HMI_FBHMI_FIX_TEXT_ALIGN,
													R_HMI_FBHMI_FIX_TEXT_VISIBILITY))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowSysType create system type label for fixed text failed");
		}

		//create LUA command fixed text label
		if(!m_pclFbhmiMgr->bCreateLabel(	R_HMI_PRIMARY_SCREEN,
													R_HMI_EN_LUA_COMMAND_FIXED_TEXT_ID,
													R_HMI_FBHMI_LUA_FIX_CMD_X * m_u8xResFactor,
													R_HMI_FBHMI_LUA_FIX_CMD_Y * m_u8yResFactor,
													R_HMI_FBHMI_LUA_FIX_CMD_WIDTH * m_u8xResFactor,
													R_HMI_FBHMI_LUA_FIX_CMD_HEIGHT * m_u8yResFactor,
													R_HMI_FBHMI_LUA_FIX_CMD_BWIDTH,
													R_HMI_FBHMI_FIX_TEXT_FG_COLOR,
													R_HMI_FBHMI_FIX_TEXT_BG_COLOR,
													R_HMI_FBHMI_FIX_TEXT_BORDER_COLOR,
													"COMMAND:",
													R_HMI_FBHMI_FIX_TEXT_ALIGN,
													R_HMI_FBHMI_FIX_TEXT_VISIBILITY))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowLUACmd create lua command fixed text label failed");
		}

      if(!strcmp(ProjectName, "AIVI"))
      {
        if(!m_pclFbhmiMgr->bCreateLabel( R_HMI_PRIMARY_SCREEN,
            R_HMI_EN_AIVI_FIXED_TEXT_ID,
            R_HMI_FBHMI_AIVI_FIX_TEXT_X * m_u8xResFactor,
            R_HMI_FBHMI_AIVI_FIX_TEXT_Y * m_u8yResFactor,
            R_HMI_FBHMI_AIVI_FIX_TEXT_WIDTH * m_u8xResFactor,
            R_HMI_FBHMI_AIVI_FIX_TEXT_HEIGHT * m_u8yResFactor,
            R_HMI_FBHMI_AIVI_FIX_TEXT_BWIDTH,
            R_HMI_FBHMI_VAR_TEXT_FG_COLOR,
            R_HMI_FBHMI_VAR_TEXT_BG_COLOR,
            R_HMI_FBHMI_VAR_TEXT_BORDER_COLOR,
            "AVM, RVC and eCall are not available while updating.",
            FBHMI_TXT_ALIGN_CENTER,
            R_HMI_FBHMI_FIX_TEXT_VISIBILITY))
        {
          LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowLUACmd create lua command fixed text label failed");
        }
      }

		//create progress bar
		if(!m_pclFbhmiMgr->bCreateProgressBar(	R_HMI_PRIMARY_SCREEN,
															R_HMI_EN_DNL_PBAR_ID,
															R_HMI_FBHMI_PROGRESS_BAR_X * m_u8xResFactor,
															R_HMI_FBHMI_PROGRESS_BAR_Y * m_u8yResFactor,
															R_HMI_FBHMI_PROGRESS_BAR_WIDTH * m_u8xResFactor,
															R_HMI_FBHMI_PROGRESS_BAR_HEIGHT * m_u8yResFactor,
															R_HMI_FBHMI_PROGRESS_BAR_BWIDTH * m_u8xResFactor,
															R_HMI_FBHMI_PROGRESS_BAR_FG_COLOR,
															R_HMI_FBHMI_PROGRESS_BAR_BG_COLOR,
															R_HMI_FBHMI_PROGRESS_BAR_BORDER_COLOR,
															strPbarText,
															R_HMI_FBHMI_PROGRESS_BAR_LABEL_ALIGN,
															R_HMI_FBHMI_PROGRESS_BAR_VISIBILITY,
															uintValue,
															R_HMI_FBHMI_PROGRESS_BAR_MAX_VALUE,
															R_HMI_FBHMI_PROGRESS_BAR_FILL_COLOR))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowProgressBar failed to create DNL progress bar");
		}

	}
}

/*************************************************************************
*
* FUNCTION: vShowOtaStaticScreen()
*
* DESCRIPTION: Displays the OTA static screen
*
*
* PARAMETER: none
*
* RETURNVALUE: none
*
*************************************************************************/

_tVoid SWURecoveryHmiComponent::vShowOtaStaticScreen()
{
     LOG_INFO("vShowOtaStaticScreen");
	_tUInt uintValue = 0;
	std::string strPbarText;
	_tChar StrOtaStatus[R_HMI_MAX_BUFFER_SIZE] = {0};
	std::stringstream  sstrPbarText;
	sstrPbarText << uintValue << "%";
	strPbarText.append(sstrPbarText.str());
	sprintf(StrOtaStatus, "Vehicle is Now Programming.");

     if(NULL != m_pclFbhmiMgr)
	{
    //create progress bar
		if(!m_pclFbhmiMgr->bCreateProgressBar(	R_HMI_PRIMARY_SCREEN,
															R_HMI_EN_DNL_PBAR_ID,
															R_HMI_FBHMI_OTA_PROGRESS_BAR_X * m_u8xResFactor,
															R_HMI_FBHMI_OTA_PROGRESS_BAR_Y * m_u8yResFactor,
															R_HMI_FBHMI_OTA_PROGRESS_BAR_WIDTH * m_u8xResFactor,
															R_HMI_FBHMI_OTA_PROGRESS_BAR_HEIGHT * m_u8yResFactor,
															R_HMI_FBHMI_OTA_PROGRESS_BAR_BWIDTH * m_u8xResFactor,
															R_HMI_FBHMI_OTA_PROGRESS_BAR_FG_COLOR,
															R_HMI_FBHMI_OTA_PROGRESS_BAR_BG_COLOR,
															R_HMI_FBHMI_OTA_PROGRESS_BAR_BORDER_COLOR,
															" ",
															R_HMI_FBHMI_OTA_PROGRESS_BAR_LABEL_ALIGN,
															R_HMI_FBHMI_OTA_PROGRESS_BAR_VISIBILITY,
															uintValue,
															R_HMI_FBHMI_OTA_PROGRESS_BAR_MAX_VALUE,
															R_HMI_FBHMI_OTA_PROGRESS_BAR_FILL_COLOR))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowProgressBar failed to create DNL progress bar");
		}

		vShowOtaProgressValue(0);
		vShowOtaProgressBar(uintValue);
	}


}

/*************************************************************************
*
* FUNCTION: vUpdateOtaDownloadResult(_tBool bResult)
*
* DESCRIPTION: Changes the Color of the Progess to indicate failure/sucess
*
* PARAMETER: StrStatus
*
* RETURNVALUE: none
*
*************************************************************************/
_tVoid SWURecoveryHmiComponent::vUpdateOtaDownloadResult(_tBool bResult)
{
      LOG_INFO("vUpdateOtaDownloadResult");

	  if( m_pclFbhmiMgr == NULL )
	{
		return;
	}

	if(bResult)
	{
		 if(!m_pclFbhmiMgr->bUpdateColor(R_HMI_PRIMARY_SCREEN, R_HMI_EN_DNL_PBAR_ID,
		                                 R_HMI_FBHMI_OTA_PROGRESS_BAR_BG_COLOR,R_HMI_FBHMI_OTA_PROGRESS_BAR_FG_COLOR,
										 R_HMI_FBHMI_OTA_PROGRESS_BAR_BORDER_COLOR,R_HMI_FBHMI_OTA_PROGRESS_BAR_SUCESS_FILL_COLOR ))
		 {

			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vUpdateOtaDownloadResult failed to update color of progress bar text");
		 }
	}
	else
	{

	    if(!m_pclFbhmiMgr->bCreateLabel(  R_HMI_PRIMARY_SCREEN,
													R_HMI_EN_OTA_FAILURE_FIXED_TEXT_ID,
													R_HMI_FBHMI_OTA_DOWNLOD_FAILURE_FIX_X * m_u8xResFactor,
													R_HMI_FBHMI_OTA_DOWNLOD_FAILURE_FIX_Y * m_u8yResFactor,
													R_HMI_FBHMI_OTA_DOWNLOD_FAILURE_FIX_WIDTH * m_u8xResFactor,
													R_HMI_FBHMI_OTA_DOWNLOD_FAILURE_FIX_HEIGHT * m_u8yResFactor,
													R_HMI_FBHMI_OTA_DOWNLOD_FAILURE_FIX_BWIDTH,
													R_HMI_FBHMI_FIX_TEXT_FG_COLOR,
													R_HMI_FBHMI_FIX_TEXT_BG_COLOR,
													R_HMI_FBHMI_FIX_TEXT_BORDER_COLOR,
													"(X)",
													R_HMI_FBHMI_FIX_TEXT_ALIGN,
													R_HMI_FBHMI_FIX_TEXT_VISIBILITY))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowLUACmd create lua command fixed text label failed");
		}

         if(!m_pclFbhmiMgr->bUpdateColor(R_HMI_PRIMARY_SCREEN, R_HMI_EN_DNL_PBAR_ID,
		                                 R_HMI_FBHMI_OTA_PROGRESS_BAR_BG_COLOR,R_HMI_FBHMI_OTA_PROGRESS_BAR_FG_COLOR,
										 R_HMI_FBHMI_OTA_PROGRESS_BAR_BORDER_COLOR,R_HMI_FBHMI_OTA_PROGRESS_BAR_FAILED_FILL_COLOR))
		 {

			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vUpdateOtaDownloadResult failed to update color of progress bar text");
		 }

	}


}

/*************************************************************************
*
* FUNCTION: vSetUpdateType
*
* DESCRIPTION: set the type of update
*
*
* PARAMETER: none
*
* RETURNVALUE: none
*
*************************************************************************/
_tVoid SWURecoveryHmiComponent::vSetUpdateType()
{
  const char *envValue=getenv("GUI_TYPE");

  if(envValue)
  {
    if(!strcmp(envValue, "ota"))
    {
      LOG_INFO("vSetUpdateType with ota enabled");
      enumUpdateType=FBHMI_OTA_UPDATE;
    }
  }

  LOG_INFO("IsOtaUpdate enabled =%d", enumUpdateType);
}

/*************************************************************************
*
* FUNCTION: vShowOtaProgressBar(_tUInt uintValue)
*
* DESCRIPTION: Displays the Ota Progress bar on the screen
*
*
* PARAMETER: uintValue
*
* RETURNVALUE: none
*
*************************************************************************/
_tVoid SWURecoveryHmiComponent::vShowOtaProgressBar(_tUInt uintValue)
{
	if(((uintValue ==  R_HMI_U32_BAR_MIN_VALUE) || (uintValue >  R_HMI_U32_BAR_MIN_VALUE))  &&
		(uintValue <=  R_HMI_U32_BAR_MAX_VALUE))
	{
		LOG_INFO("DNL: dl_HMISysProgController::Progress value is correct ");
	}
	else
	{
		uintValue = 0;
		LOG_INFO("DNL: dl_HMISysProgController::Progress value is cut short to 0 ");
	}

	/*std::string strPbarText;
	std::stringstream  sstrPbarText;
	sstrPbarText << uintValue << "/100";
	strPbarText.append(sstrPbarText.str());*/

	if( m_pclFbhmiMgr != NULL )
	{
		//update prog bar value
		if(!m_pclFbhmiMgr->bUpdateProgress(R_HMI_PRIMARY_SCREEN, R_HMI_EN_DNL_PBAR_ID, uintValue, R_HMI_FBHMI_PROGRESS_BAR_MAX_VALUE))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowProgressBar failed to update DNL progress bar value");
		}
		//update prog bar text
		/*if(!m_pclFbhmiMgr->bUpdateText(R_HMI_PRIMARY_SCREEN, R_HMI_EN_DNL_PBAR_ID, strPbarText, FBHMI_TXT_ALIGN_CENTER, true))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowProgressBar failed to update DNL progress bar text");
		}*/

	}
}

/*************************************************************************
*
* FUNCTION: vShowOtaProgressValue(_tUInt uintValue)
*
* DESCRIPTION: Displays the Ota Progress bar on the screen
*
*
* PARAMETER: uintValue
*
* RETURNVALUE: none
*
*************************************************************************/
_tVoid SWURecoveryHmiComponent::vShowOtaProgressValue(_tUInt uintValue)
{
	static _tBool bProgressValueInit= FALSE;

	if(((uintValue ==  R_HMI_U32_BAR_MIN_VALUE) || (uintValue >  R_HMI_U32_BAR_MIN_VALUE))  &&
		(uintValue <=  R_HMI_U32_BAR_MAX_VALUE))
	{
		LOG_INFO("DNL: dl_HMISysProgController::Progress value is correct ");
	}
	else
	{
		uintValue = 0;
		LOG_INFO("DNL: dl_HMISysProgController::Progress value is cut short to 0 ");
	}

	std::string strPbarText;
	std::stringstream  sstrPbarText;
	sstrPbarText << uintValue << "%";
	strPbarText.append(sstrPbarText.str());

	if(bProgressValueInit == FALSE)
	{
		//create source label variable text
		if(!m_pclFbhmiMgr->bCreateLabel(	R_HMI_PRIMARY_SCREEN,
													R_HMI_EN_OTA_PROGRESS_VAR_TEXT_ID,
													R_HMI_FBHMI_OTA_DOWNLOD_PROGRESS_VALUE_VAR_X * m_u8xResFactor,
													R_HMI_FBHMI_OTA_DOWNLOD_PROGRESS_VALUE_VAR_Y * m_u8yResFactor,
													R_HMI_FBHMI_OTA_DOWNLOD_PROGRESS_VALUE_VAR_WIDTH * m_u8xResFactor,
													R_HMI_FBHMI_OTA_DOWNLOD_PROGRESS_VALUE_VAR_HEIGHT * m_u8yResFactor,
													R_HMI_FBHMI_OTA_DOWNLOD_PROGRESS_VALUE_VAR_BWIDTH,
													R_HMI_FBHMI_VAR_TEXT_FG_COLOR,
													R_HMI_FBHMI_VAR_TEXT_BG_COLOR,
													R_HMI_FBHMI_VAR_TEXT_BORDER_COLOR,
													strPbarText,
													R_HMI_FBHMI_VAR_TEXT_ALIGN,
													R_HMI_FBHMI_VAR_TEXT_VISIBILITY))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowSource create source label for variable text failed");
		}
		else
		{
			bProgressValueInit = TRUE;
		}
	}
	else
	{
		//update source texts
		if(!m_pclFbhmiMgr->bUpdateText(R_HMI_PRIMARY_SCREEN, R_HMI_EN_OTA_PROGRESS_VAR_TEXT_ID, strPbarText, FBHMI_TXT_ALIGN_LEFT, true))
		{
			LOG_INFO("DNL_FBHMI: dl_HMISysProgController::vShowSource failed to update source text");
		}
	}
}

} // imp
} // recovery_hmi
} //common
}// ai_sw_update


