/************************************************************************
 * File: fbhmi_Utility.h
 * SW-Component: 
 * Description: utilty functions used by fbhmi_surface for drawing on linux frame buffer
 *   
 * Author:
 *	Rohit.ChannappiahRaman@in.bosch.com
 * Copyright:
 *   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
 *
 * History:
 * 06.06.2013 - Initial version - Rohit.ChannappiahRaman@in.bosch.com
 ***********************************************************************/

#ifndef _FBHMI_UTILITY_H_
#define _FBHMI_UTILITY_H_
using namespace std;
#include "fbhmi_Global.h"
#include <stdint.h>
#include <vector>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>
#include <endian.h>
#include <libgen.h>
#include "fbhmi_Surface.h"
#include "Fonts/fbhmi_Font.h"

#define	UNI_MAX_LEGAL_UTF32   (_tU32)0x0010FFFF
#define UNI_SUR_HIGH_START    (_tU32)0xD800
#define UNI_SUR_HIGH_END      (_tU32)0xDBFF
#define UNI_SUR_LOW_START     (_tU32)0xDC00
#define UNI_SUR_LOW_END       (_tU32)0xDFFF
#define UNI_REPLACEMENT_CHAR  (_tU32)0x0000FFF

class fbhmi_Utility
{
public:
	fbhmi_Utility();
	~fbhmi_Utility();

	static _tU32 u32UstrLen(_tU32 *pu32str);
	static _tVoid vUstrCat(_tU32 *pu32buff, _tU32 u32chr);
	static _tU32* pu32UstrDup(_tU32 *pu32buff);
	static _tVoid vSplitStringSpaces(_tU32 *pu32wbuf, vector<_tU32 *> &vecParts);
	static _tVoid vSplitStringDirection(_tU32 *pu32wbuf, vector<_tU32 *> &vecParts);
	static _tBool bIsWhiteChar(_tU32 u32Chr);
	static _tU32 u32GetStringPixelLength(_tU32 *pu32Part);
	static _tVoid vConvlatin9toutf32(_tChar *pcharLatin, _tU32 *pcharUtf32, _tU32 u32Len);
    static _tS32 u32GetPresentionAdvance(_tU32 u32Pres,_tBool &pbToDraw);
	
private:
	static _tU32 u32GetPresentation(_tU32 *pu32Part, _tU32& pu32X);
	static _tChar* pcharLatin2utf8(const _tChar *const pcharString);
	static _tBool bIsLegalUTF8(const _tChar *pcharSource, _tS32 s32Length);
	static _tBool bUtf8toutf32(const _tChar* pcharSource, _tU32* pcharUtf32);
};

#endif 

