/************************************************************************
 * File: fbhmi_Surface.cpp
 * SW-Component:
 * Description: The class helps in drawing the graphics using the linux framebuffer.
 * Author:
 *   Rohit.ChannappiahRaman@in.bosch.com
 * Copyright:
 *   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
 *
 * History:
 * 10.06.2013 - Skeleton code - Rohit.ChannappiahRaman@in.bosch.com
 * 13.06.2013 - Initial Version - Gururaj.B@in.bosch.com
 ***********************************************************************/
#ifndef _FBHMI_SURFACE_H_
#define _FBHMI_SURFACE_H_

#include "fbhmi_Color.h"
#include "Fonts/fbhmi_Font.h"
#include "fbhmi_Utility.h"
#include "fbhmi_FbHandler.h"
#include "fbhmi_KmsHandler.h"

class fbhmi_Font;
class fbhmi_GfxHandler;

class fbhmi_Surface
{
public:
	static fbhmi_Surface* pGetInstance();
  static fbhmiDisplayType DisplayType;

	_tVoid vSetColor(fbhmi_Color tclColor) { this->m_tclColor = tclColor; };
	_tVoid vSetColor(_tU32 u32Argb) { this->m_tclColor.vSetARGB(u32Argb); };
	fbhmi_Color tclGetColor() { return this->m_tclColor; };

	_tVoid vSetFont(fbhmi_Font *pFont) { this->m_pFontHandle = pFont; };
	fbhmi_Font* pGetFont() { return this->m_pFontHandle; };

	_tVoid vDrawChar(_tU32 u32Ch, _tU32 u32x, _tU32 u32y);
	_tVoid vSetPixel(_tU32 u32x, _tU32 u32y);
	_tVoid vFillRectangle(_tU32 u32x, _tU32 u32y, _tU32 u32Width, _tU32 u32Height);
	_tVoid vDrawLine(_tU32 u32x1, _tU32 u32y1, _tU32 u32x2, _tU32 u32y2);

	_tU32* pGetMemory() { return this->m_pu32Memory; };

	_tVoid vClearSurface();

	_tU32 u32GetXRes() { return this->m_u32XRes; };
	_tU32 u32GetYRes() { return this->m_u32YRes; };

	static _tU32 u32DrawStringNormal(_tU32 *pu32Wbuf, _tU32 u32Xx, _tU32 u32Yy);
	static _tVoid vDrawString(_tU32 *pu32Wbuf, _tU32 u32Xx, _tU32 u32Yy);
	_tVoid vDrawToFrameBuffer();

	_tVoid vDeleteSurfaceHandler();

public:
    fbhmi_Font* m_pFontHandle;

private:
	fbhmi_Surface(_tU32 u32x, _tU32 u32y);
	~fbhmi_Surface();

	fbhmi_Color m_tclColor;

	fbhmi_GfxHandler* m_pGfxHandle;

	_tU32	m_u32XRes;
	_tU32	m_u32YRes;
	_tU32*	m_pu32Memory;
	static _tBool m_bCreated;
	static fbhmi_Surface* m_pSurfaceHandle;
};

#endif
