/************************************************************************
* File: fbhmi_QueueHandler.h
* SW-Component: 
* Description: Manages the queue for handling HMI events
* Author:
*	Rohit.ChannappiahRaman@in.bosch.com
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 06.06.2013 - Initial version - Rohit.ChannappiahRaman@in.bosch.com
* 14.06.2013 - Adapted for first release - Gururaj.B@in.bosch.com
***********************************************************************/

#ifndef _FBHMI_QUEUEHANDLER_H_
#define _FBHMI_QUEUEHANDLER_H_

#include <pthread.h>
using namespace std;
#include "Requests/fbhmi_Request.h"
#include <queue>
class fbhmi_Request;

class fbhmi_QueueHandler
{
public:
    fbhmi_QueueHandler();
    virtual ~fbhmi_QueueHandler();

    fbhmi_Request * pQueueFront();
    _tBool bIsQueueEmpty() const;
    _tVoid vPopQueue();
    _tBool bPushQueue(fbhmi_Request* pReq);
    _tU32 u32GetQueueSize() const;
	
	_tBool vWaitMQ();
	_tBool vLockMQ();
	_tBool vUnlockMQ();
	_tBool	m_isQLocked;
private:
    queue<fbhmi_Request*> m_qRequestQueue;
	pthread_mutex_t mq_mutex;
	pthread_cond_t mq_count;
};

#endif 
