/************************************************************************
 * File: fbhmi_FbHandler.h
 * SW-Component: ASCII HMI for recovery download
 *
 * Description:
 *   This is a singleton class used to initialize and use the Linux
 *   framebuffer for displaying characters.
 * Author:
 *   Gururaj.B@in.bosch.com
 * Copyright:
 *   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
 *
 * History:
 * 21.05.2013 - Initial version - Gururaj.B@in.bosch.com
 ***********************************************************************/
#ifndef _FBHMI_KMSHANDLER_
#define _FBHMI_KMSHANDLER_
#include <sys/ioctl.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/mman.h>
#include <linux/fb.h>     // Still needed for fb_fix_screeninfo and fb_var_screeninfo
#include <xf86drm.h>
#include <xf86drmMode.h>
#include <iostream>
#include "fbhmi_Global.h"
#include "fbhmi_GfxHandler.h"
using namespace std;

class fbhmi_KmsHandler : fbhmi_GfxHandler
{
protected:
    struct kms_dev
    {
      struct kms_dev  *next;

      uint32_t  width;
      uint32_t  height;
      uint32_t  stride;
      uint32_t  size;
      uint32_t  handle;
      uint8_t   *map;

      drmModeModeInfo mode;
      uint32_t        fb;
      uint32_t        conn;
      uint32_t        crtc;
      drmModeCrtc     *saved_crtc;
    };

  _tS32 m_s32FdKms;
  struct kms_dev    *m_DevList;

  _tBool  bInitKmsBuffer(const _tChar *pFbName);
  _tBool  bGetKmsInfo(void);
  _tBool  bSetupKmsDev(drmModeRes *res, drmModeConnector *conn, struct kms_dev *dev);
  _tBool  bFindCrtc(drmModeRes *res, drmModeConnector *conn, struct kms_dev *dev);
  _tBool  bCreateFb(struct kms_dev *dev);
  _tBool  bCleanupKmsBuffer(void);
  fbhmi_KmsHandler();

public:
  virtual ~fbhmi_KmsHandler();
  static fbhmi_GfxHandler* pCreateInstance(void);
};
#endif

