/************************************************************************
 * File: fbhmi_FbHandler.h
 * SW-Component: ASCII HMI for recovery download
 *
 * Description:
 *   This is a singleton class used to initialize and use the Linux
 *   framebuffer for displaying characters.
 * Author:
 *   Gururaj.B@in.bosch.com
 * Copyright:
 *   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
 *
 * History:
 * 21.05.2013 - Initial version - Gururaj.B@in.bosch.com
 ***********************************************************************/
#ifndef _FBHMI_FBHANDLER_
#define _FBHMI_FBHANDLER_
#include <sys/ioctl.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/mman.h>
#include <linux/fb.h>
#include <iostream>
#include "fbhmi_Global.h"
#include "fbhmi_GfxHandler.h"
using namespace std;

class fbhmi_FbHandler : fbhmi_GfxHandler
{
protected:
  _tS32 m_s32FdFrameBuffer;

  _tBool          bInitFrameBuffer(const _tChar *pFbName);
  _tBool          bGetFbInfo();
  virtual _tBool  bCleanupFrameBuffer();
  _tBool          bVerifyDtbConfig();
  void            vOverrideDisplayConfig();
  static _tU32    u32ConvertRaw32(const char *pchTempStr);
  void            vSetDtbsConfigure(const char * pchTempStr, _tU32 u32TempVal);
  _tU32           u32ReadDtbID();
  fbhmi_FbHandler();

public:
  virtual         ~fbhmi_FbHandler();
  static fbhmi_GfxHandler* pCreateInstance();
};
#endif

