/************************************************************************
* File: fbhmi_Color.h
* SW-Component: ASCII HMI for recovery download
*
* Description:
*   This is a singleton class used to initialize and use the Linux
*   framebuffer for displaying characters. 
* Author:
*   Adityakumar.jha@in.bosch.com
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 07.06.2013 - Initial version - Adityakumar.jha@in.bosch.com
************************************************************************/
#ifndef _FBHMI_COLOR_H_
#define _FBHMI_COLOR_H_
#include "fbhmi_Global.h"

#include <stdint.h>

class fbhmi_Color
{
public:
    fbhmi_Color() { this->u32ArgbVal = 0x00000000; };
    fbhmi_Color(_tU32 u32Argb);
    ~fbhmi_Color() {};

    _tU32 getARGB() { return u32ArgbVal; };
	_tVoid vSetARGB(_tU32 u32Argb) { u32ArgbVal = u32Argb; };
    _tU8 getRed() { return (getARGB() >> 16)	& 0xFF; };
    _tU8 getGreen() { return (getARGB() >> 8) & 0xFF; };
    _tU8 getBlue() { return (getARGB() >> 0) & 0xFF; };
    _tU8 getAlpha() { return (getARGB() >> 24) & 0xFF;};

private:
    _tU32 u32ArgbVal;
};

#endif
