/************************************************************************
* File: fbhmi_Widget.cp
* SW-Component: 
* Description: The base class for all widgets contains generic widget functionality.
* Author:
*	Rohit.ChannappiahRaman@in.bosch.com
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 06.06.2013 - Initial version - Rohit.ChannappiahRaman@in.bosch.com
***********************************************************************/

#include "fbhmi_Widget.h"
//#define COLOR_REQ(pReq) dynamic_cast<fbhmi_ColorReq *>(pReq)

/************************************************************************
* FUNCTION: fbhmi_Widget::fbhmi_Widget()
*
* DESCRIPTION: Parameterized Constructor
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
fbhmi_Widget::fbhmi_Widget(_tU16 u16Id ,
                           _tU32 u32x,
                           _tU32 u32y,
                           _tU32 u32Height ,
                           _tU32 u32Width ,
                           _tU16 u16BdrWidth ,
                           _tU32 u32BgColor ,
                           _tU32 u32FgColor ,
                           _tU32 u32BdrColor,
                           _tU32 u32FillColor ,
                           string sText ,
                           _tU8 u8Align ,
                           _tBool bVisible ,
                           _tU32 u32PbarVal,
                           _tU32 u32PbarMax)
{
    m_u16Id         = u16Id;
    m_u32x          = u32x;
    m_u32y          = u32y;
    m_u32Height     = u32Height;
    m_u32Width      = u32Width;
    m_u16BdrWidth   = u16BdrWidth;
    m_u32BgColor    = u32BgColor;
    m_u32FgColor    = u32FgColor;
    m_u32BdrColor   = u32BdrColor;
    m_u32FillColor  = u32FillColor;
    m_strText       = sText;
    m_u8Align       = u8Align;
    m_bVisible      = bVisible;
    m_u32PbarVal    = u32PbarVal;
    m_u32PbarMax    = u32PbarMax;
    m_pSurfaceHandle = fbhmi_Surface::pGetInstance();
    if(NULL == m_pSurfaceHandle)
    {
        // Debug Log
    }
    DEBUG_TRACE("%s", __func__);
}

/************************************************************************
* FUNCTION: fbhmi_Widget::fbhmi_Widget()
*
* DESCRIPTION: Parameterized Constructor
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
fbhmi_Widget::fbhmi_Widget(fbhmi_Request *pReq)
{

    fbhmi_WidgetReq *pclWdgReq = dynamic_cast<fbhmi_WidgetReq*>(pReq);

    m_u16Id			= FBHMI_WIDGET_DEF_ID;
    m_u32x			= FBHMI_WIDGET_DEF_X;
    m_u32y			= FBHMI_WIDGET_DEF_Y;
    m_u32Height		= FBHMI_WIDGET_DEF_HEIGHT;
    m_u32Width		= FBHMI_WIDGET_DEF_WIDTH;
    m_u16BdrWidth	= FBHMI_WIDGET_DEF_BWIDTH;
    m_u32BgColor	= FBHMI_WIDGET_DEF_BGCOLOR;
    m_u32FgColor	= FBHMI_WIDGET_DEF_FGCOLOR;
    m_u32BdrColor	= FBHMI_WIDGET_DEF_BDRCOLOR;
    m_u32FillColor	= FBHMI_WIDGET_DEF_FILCOLOR;
    m_strText		= FBHMI_WIDGET_DEF_TEXT;
    m_u8Align		= FBHMI_WIDGET_DEF_ALIGN;
    m_bVisible		= FBHMI_WIDGET_DEF_VISIBLE;
    m_u32PbarVal	= FBHMI_WIDGET_DEF_PBARVAL;
    m_u32PbarMax	= FBHMI_WIDGET_DEF_PBARMAX;

    if(NULL != pReq && NULL != pclWdgReq)
    {
        m_u16Id			= pclWdgReq->m_u16WidgetID;
        m_u32x			= pclWdgReq->m_u32x;
        m_u32y			= pclWdgReq->m_u32y;
        m_u32Height		= pclWdgReq->m_u32height;
        m_u32Width		= pclWdgReq->m_u32width;
        m_u16BdrWidth	= pclWdgReq->m_u32borderWidth;
        m_u32BgColor	= pclWdgReq->m_u32bgColor;
        m_u32FgColor	= pclWdgReq->m_u32fgColor;
        m_u32BdrColor	= pclWdgReq->m_u32borderColor;
        m_u32FillColor	= pclWdgReq->m_u32fillColor;
        m_strText		= pclWdgReq->m_strText;
        m_u8Align		= pclWdgReq->m_u32textAlign;
        m_bVisible		= pclWdgReq->m_bvisibility;
        m_u32PbarVal	= pclWdgReq->m_u32value;
        m_u32PbarMax	= pclWdgReq->m_u32maxValue;
    }	

    m_pSurfaceHandle = fbhmi_Surface::pGetInstance();

    if(NULL == m_pSurfaceHandle)
    {
        DEBUG_TRACE("Surface pointer is NULL");
    }
    DEBUG_TRACE("%s", __func__);
}

/************************************************************************
* FUNCTION: fbhmi_Widget::~fbhmi_Widget()
*
* DESCRIPTION: Destructor
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
fbhmi_Widget::~fbhmi_Widget()
{
    m_pSurfaceHandle = NULL;
    DEBUG_TRACE("%s", __func__);
}



/************************************************************************
* FUNCTION: fbhmi_Widget::vClearWidget()
*
* DESCRIPTION: Clear Widget stuff from Surface
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
_tVoid fbhmi_Widget::vClearWidget(_tU32 u32ClearColor)
{
    if (NULL == m_pSurfaceHandle){
        DEBUG_TRACE("Surface pointer is NULL");
        return;
    }
    m_pSurfaceHandle->vSetColor(u32ClearColor);
    m_pSurfaceHandle->vFillRectangle(m_u32x, m_u32y, m_u32Width, m_u32Height);
}

/************************************************************************
* FUNCTION: fbhmi_Widget::vUpdateWidget()
*
* DESCRIPTION: Update widget properties
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
_tVoid fbhmi_Widget::vUpdateWidget(fbhmi_Request* pReq)
{
    DEBUG_TRACE("%s", __func__);

    if( NULL == pReq)
    {
        DEBUG_TRACE("Request pointer is NULL");
        return;
    }

    _tU16 u16ReqId = pReq->m_u16RequestID;

    switch(u16ReqId)
    {
    case FBHMI_EVNT_UPDATE_COLOR:
        {
            fbhmi_ColorReq * pclClrReq = dynamic_cast<fbhmi_ColorReq *>(pReq);
            if(NULL != pclClrReq)
            {
                m_u32BgColor	= pclClrReq->m_u32BgColor;
                m_u32FgColor	= pclClrReq->m_u32FgColor;
                m_u32BdrColor	= pclClrReq->m_u32BdrColor;
                m_u32FillColor	= pclClrReq->m_u32FillColor;
            }
        }
        break;
    case FBHMI_EVNT_UPDATE_DIMENSION:
        {
            fbhmi_DimensionReq* pclDimReq ;
            pclDimReq = dynamic_cast<fbhmi_DimensionReq *>(pReq);
            if(NULL != pclDimReq)
            {
                m_u32Height		= pclDimReq->m_u32Height;
                m_u32Width		= pclDimReq->m_u32Width;
                m_u16BdrWidth	= pclDimReq->m_u32BdrWidth;
            }
        }
        break;

    case FBHMI_EVNT_UPDATE_PROGRESSBAR:
        {
            fbhmi_ProgressReq *pclPrgReq;
            pclPrgReq = dynamic_cast<fbhmi_ProgressReq *>(pReq);
            if(NULL != pclPrgReq)
            {
                m_u32PbarVal = pclPrgReq->m_u32PbarVal;
                m_u32PbarMax = pclPrgReq->m_u32PbarMax;
            }
        }
        break;

    case FBHMI_EVNT_UPDATE_POSITION:
        {
            fbhmi_PositionReq * pclPosReq;
            pclPosReq = dynamic_cast<fbhmi_PositionReq*>(pReq);
            if(NULL != pclPosReq)
            {
                m_u32x = pclPosReq->m_u32x;
                m_u32y = pclPosReq->m_u32y;
            }
        }
        break;

    case FBHMI_EVNT_UPDATE_TEXT:
        {
            fbhmi_TextReq * pclTxtReq;
            pclTxtReq = dynamic_cast<fbhmi_TextReq*>(pReq);
            if(NULL != pclTxtReq)
                m_strText = pclTxtReq->m_strText;
        }
        break;

    case FBHMI_EVNT_UPDATE_TEXT_ALIGN:
        {
            fbhmi_TextReq * pclTxtReq;
            pclTxtReq = dynamic_cast<fbhmi_TextReq*>(pReq);
            if(NULL != pclTxtReq)
                m_u8Align = pclTxtReq->m_u8Align;
        }
        break;

    case FBHMI_EVNT_UPDATE_VISIBILITY:
        {
            fbhmi_TextReq * pclTxtReq;
            pclTxtReq = dynamic_cast<fbhmi_TextReq*>(pReq);
            if(NULL != pclTxtReq)
                m_bVisible = pclTxtReq ->m_bVisible;
        }
        break;
    default:
        break;
    }
    this->vDrawWidget();
}

/************************************************************************
* FUNCTION: fbhmi_Screen::bAddChilvGetAlignedXY
*
* DESCRIPTION: Draw widget function
*
* PARAMETER: None
*
* RETURNVALUE: None
*************************************************************************/
_tVoid fbhmi_Widget::vGetAlignedXY(_tU32* pu32AlndX, _tU32 *pu32AlndY, _tU32 u32Strlen)
{
    if (NULL == m_pSurfaceHandle){
        DEBUG_TRACE("Surface pointer is NULL");
        return;
    }
    _tU32 u32FontHeight = m_pSurfaceHandle->m_pFontHandle->u32GetFontHeight();
    _tU32 u32FontWidth = m_pSurfaceHandle->m_pFontHandle->u32GetFontWidth();
    _tU32 u32StringWidth = u32FontWidth * u32Strlen;
    // TODO: gub3kor Read BBX from BDF Font and remove hardcoded 4
    _tU32 u32TempY = this->m_u32y + u32FontHeight + ((this->m_u32Height/2) - (u32FontHeight/2)) - 4;
    *pu32AlndY = u32TempY;

    _tU32 u32TempX = this->m_u32x;

    switch(m_u8Align)
    {
    case FBHMI_TXT_ALIGN_LEFT:
        break;
    case FBHMI_TXT_ALIGN_RIGHT:
        u32TempX = this->m_u32x + ((this->m_u32Width) - u32StringWidth);
        break;
    case FBHMI_TXT_ALIGN_CENTER:
    default:
        u32TempX = this->m_u32x + ((this->m_u32Width/2) - (u32StringWidth/2));
        break;
    }
    *pu32AlndX = u32TempX;
    DEBUG_TRACE("X:%u Y:%u StrLen: %u", *pu32AlndX, *pu32AlndY, u32Strlen);
}

