/************************************************************************
* File: fbhmi_Screen.h
* SW-Component: ASCII HMI for recovery download
*
* Description:
*   Screen class declaration. 
* Author:
*   Gururaj.B@in.bosch.com
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 13.06.2013 - Initial version - Gururaj.B@in.bosch.com
* 08.09.2014 - Added vDrawTitle and vClearTitle - Apoorva K R
***********************************************************************/
#ifndef _FBHMI_SCREEN_H_
#define _FBHMI_SCREEN_H_
#include "fbhmi_Widget.h"
#include "fbhmi_Label.h"
#include "fbhmi_ProgressBar.h"
#include "../fbhmi_Global.h"
#include "../Requests/fbhmi_Request.h"
#include<vector>
using namespace std;
class fbhmi_Widget;
class fbhmi_Request;

class fbhmi_Screen : public fbhmi_Widget
{
public:
    fbhmi_Screen(fbhmi_Request* pReq);
    fbhmi_Screen(   _tU16 u16Id = FBHMI_SCREEN_DEF_ID,\
                    _tU32 u32x = FBHMI_SCREEN_DEF_X,\
                    _tU32 u32y = FBHMI_SCREEN_DEF_Y,\
                    _tU32 u32Height = FBHMI_SCREEN_DEF_HEIGHT,\
                    _tU32 u32Width = FBHMI_SCREEN_DEF_WIDTH,\
                    _tU16 u16BdrWidth = FBHMI_WIDGET_DEF_BWIDTH,\
                    _tU32 u32BgColor = FBHMI_WIDGET_DEF_BGCOLOR,\
                    _tU32 u32FgColor = FBHMI_WIDGET_DEF_FGCOLOR,\
                    _tU32 u32BdrColor = FBHMI_WIDGET_DEF_BDRCOLOR,\
                    _tU32 u32FillColor = FBHMI_WIDGET_DEF_FILCOLOR,\
                    string sText = FBHMI_WIDGET_DEF_TEXT,\
                    _tU8 u8Align = FBHMI_WIDGET_DEF_ALIGN,\
                    _tBool bVisible = FBHMI_WIDGET_DEF_VISIBLE);

    virtual ~fbhmi_Screen();
    _tVoid vDrawWidget();
    _tVoid vDrawTitle();
    _tVoid vClearTitle();
    _tVoid vClearScreen();
    //_tVoid vUpdateWidget(fbhmi_Request* pReq);
    _tBool bAddChildWidget(fbhmi_Request* pReq);
    _tU16  u16GetScreenId();
	_tVoid vUpdateWidget(fbhmi_Request* pReq);
    _tVoid vGetAlignedXY(_tU32* pu32AlndX, _tU32 *pu32AlndY, _tU32 u32Strlen);
private:
    _tBool m_bRescalable;
    std::vector<fbhmi_Widget *> m_vecChildWidgets;
    fbhmi_Widget* pGetChildWidget(_tU16 u16Id);
};

#endif

