/************************************************************************
* File: fbhmi_Font.h
* SW-Component: ASCII HMI for recovery download
*
* Description:
*   This is a singleton class used to initialize and use the Linux
*   framebuffer for displaying characters. 
* Author:
*   Adityakumar.jha@in.bosch.com
* Copyright:
*   Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
* History:
* 07.06.2013 - Initial version - Adityakumar.jha@in.bosch.com
* 13.06.2013 - Updated for first release - Gururaj.B@in.bosch.com
* 14.06.2013 - Updated for first release - Rohit.ChannappiahRaman@in.bosch.com
* 19.03.2014 - Added s32GetFontXPlus() and s32GetFontYPlus()- Aditya Kumar Jha
************************************************************************/
#ifndef _FBHMI_FONT_H_
#define _FBHMI_FONT_H_

#include <exception>
#include <string>
#include <stdint.h>
#include "../fbhmi_Global.h"
#include "../fbhmi_Surface.h"

using namespace std;

class fbhmi_Surface;

class fbhmi_Font {
public:
	// creates font from fileName.
	// FileName must end with extesion
	static fbhmi_Font *pclCreateFromFile(const string fontFileName);

	virtual _tVoid vSetPixelSize(_tS32 size);	
	virtual _tVoid vDrawBlock(fbhmi_Surface *graphics, _tU32 u32PosX, _tU32 u32PosY);
	virtual _tVoid vDrawChar(fbhmi_Surface *graphics, _tU32 u32Ch, _tU32 u32PosX, _tU32 u32PosY)=0;
    virtual _tBool bIsCharDefined(_tU32 u32Ch){ /*For lint*/u32Ch = u32Ch; _tBool bTemp = true; return bTemp;}
    /**!!!!!!!!!!!!!Warning This function has to be defined !!!!!!!!!!!*/
	/*virtual _tU32 u32GetAdvanceX(_tU32 ch){ _tU32 u32Temp = 1; return u32Temp;};
	virtual _tU32 u32GetAdvanceY(_tU32 ch){ _tU32 u32Temp = 1; return u32Temp;};
    */
    virtual _tS32 s32GetAdvanceX(_tU32 u32Ch) = 0;
    virtual _tS32 s32GetAdvanceY(_tU32 u32Ch) = 0;
	_tS32 s32GetPixelSize();

    virtual _tU32 u32GetFontWidth(){ return 0;};
    virtual _tU32 u32GetFontHeight(){ return 0;};
	virtual _tS32 s32GetFontXPlus(){ return 0;};
    virtual _tS32 s32GetFontYPlus(){ return 0;};
    virtual ~fbhmi_Font();

protected:
	_tU32 u32GetRealCharIndex(_tU32 ch);
	_tS32 m_s32PixelSize;
	fbhmi_Font();
	
};

class fbhmi_FontException: public std::exception
{
public:
	fbhmi_FontException(const _tChar* msg) { this->message = msg; };
	virtual const _tChar *what() const throw() { return message; };
private:
	const _tChar *message;
};
#endif //_FBHMI_FONT_H_
