///////////////////////////////////////////////////////////////////////////////
//
// File: swupd_fsmMCPUpd.h
//
// Generated by SMC 4.5.5 (C++ State Pattern Code Generator)
//
// Command Line Arguments:
//
//   -c swupd_fsmMcpUpd.fsm
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __INCLUDED_SWUPD_FSMMCPUPD__
#define __INCLUDED_SWUPD_FSMMCPUPD__

using namespace std;
#include <iostream>
#include <string>
#include <stdlib.h>
#include <cstdlib>


namespace swupd_fsmMCPUpd
{

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody;

///////////////////////////////////////////////////////////////////////////////
//
// Enums and typedefs
//
///////////////////////////////////////////////////////////////////////////////

//! enumeration of FSM events. First and last item added by SMC
enum FsmEvent
{
   evUnknown = 0,
   evCriticalError,
   evDataNotSentConfirmation,
   evDataSentConfirmation,
   evDefaultSession,
   evDistribute,
   evEvalNext,
   evEvalTimeout,
   evEvaluation,
   evGetError,
   evGetResult,
   evNRC21Recieved,
   evReadMCPSWVersion,
   evReadyToDo,
   evResponseReceived,
   evTimeout,
   evUDSRequest,
   evUDSRequestFailed,
   evUDSRequestSuccess,
   evCount
};

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event );

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBehaviour
//
// This is the base class for the FSM server (provides implementation for all
// actions and guards)
//
///////////////////////////////////////////////////////////////////////////////

class FsmBehaviour
{ 
public:
   virtual ~FsmBehaviour ( void ) {}

   // FSM actions
   virtual void actCompleteReadMCPSWVersion ( void* pArg ) = 0;
   virtual void actDecNRC27Count ( void* pArg ) = 0;
   virtual void actEvalPreDistributeStatus ( void* pArg ) = 0;
   virtual void actEvaluateRequestResponse ( void* pArg ) = 0;
   virtual void actEvaluateTimeout ( void* pArg ) = 0;
   virtual void actExit ( void* pArg ) = 0;
   virtual void actFillBufferForDefaultSessionRequest ( void* pArg ) = 0;
   virtual void actFillBufferForExtendedSessionRequest ( void* pArg ) = 0;
   virtual void actFillBufferForPreDistribute ( void* pArg ) = 0;
   virtual void actFillBufferForProgrammingSessionRequest ( void* pArg ) = 0;
   virtual void actFillBufferForReadMCPSWVersion ( void* pArg ) = 0;
   virtual void actFillBufferForRequestDownloadStartRequest ( void* pArg ) = 0;
   virtual void actFillBufferForRequestEraseMemoryRequest ( void* pArg ) = 0;
   virtual void actFillBufferForRequestKeyRequest ( void* pArg ) = 0;
   virtual void actFillBufferForRequestSeedRequest ( void* pArg ) = 0;
   virtual void actFillBufferForSendNewVersion ( void* pArg ) = 0;
   virtual void actHandlePreDistributeError ( void* pArg ) = 0;
   virtual void actNRC27Received ( void* pArg ) = 0;
   virtual void actOnCriticalError ( void* pArg ) = 0;
   virtual void actPreparePreDistribute ( void* pArg ) = 0;
   virtual void actPrintCurrentState ( void* pArg ) = 0;
   virtual void actResetRetrycounter ( void* pArg ) = 0;
   virtual void actRestartTimerLong ( void* pArg ) = 0;
   virtual void actSendRequest ( void* pArg ) = 0;
   virtual void actStartTimer ( void* pArg ) = 0;
   virtual void actStopDistributeAndReturnError ( void* pArg ) = 0;
   virtual void actStopTimer ( void* pArg ) = 0;
   virtual void actStopUpdate ( void* pArg ) = 0;
   virtual void actStoreDistribute ( void* pArg ) = 0;
   virtual void actStoreSeed ( void* pArg ) = 0;
   virtual void actUDSRequestFailed ( void* pArg ) = 0;
   virtual void actWaitForJumpToBoot ( void* pArg ) = 0;

   // FSM guards
   virtual bool IfError ( void* pArg ) = 0;
   virtual bool ifExistNextPreDistribute ( void* pArg ) = 0;
   virtual bool ifFlashFileNotExists ( void* pArg ) = 0;
   virtual bool ifLastPreDistributeSuccess ( void* pArg ) = 0;
   virtual bool ifLessThanMaxNoOfTimeout ( void* pArg ) = 0;
   virtual bool ifLessThanMaxNoOfTrials ( void* pArg ) = 0;
   virtual bool ifNotNRC27Received ( void* pArg ) = 0;
   virtual bool ifNRC27CountNotZero ( void* pArg ) = 0;
   virtual bool ifNRC27Received ( void* pArg ) = 0;
   virtual bool ifPreDistributeSuccess ( void* pArg ) = 0;
   virtual bool ifResponseWasForLastRequest ( void* pArg ) = 0;
   virtual bool ifRetryCountNotExceeded ( void* pArg ) = 0;
   virtual bool ifRetryRequired ( void* pArg ) = 0;
   virtual bool IfUDSRequestFailed ( void* pArg ) = 0;
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: Fsm
//
// This is the finite state machine class 'swupd_fsmMCPUpd'.
//
///////////////////////////////////////////////////////////////////////////////

class Fsm
{
    //! we grant the body class access to our protected section
    friend class FsmBody;

public:
    //! class constructor
    Fsm ( FsmBehaviour* behaviour );
    //! class destructor
    virtual ~Fsm ( void );

    //! setup and initialize the state machine
    virtual void init ( void );

    //! this method is used to stimulate the FSM with events
    virtual void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the current state
    virtual const char* getStateName ( void ) const;

protected:
    //! protected default constructor to avoid usage
    Fsm ( void );
    //! copy constructor without implementation
    Fsm ( const Fsm& obj );
    //! assignment operator without implementation
    Fsm& operator = ( const Fsm& obj );

protected:
    //! pointer to the server that provides the implementation for the actions and guards
    FsmBehaviour* mpBehaviour;
    //! body of the FSM implementation
    FsmBody* mpBody;
};


} // namespace

#endif
